package com.rocogz.syy.order.entity.pay;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 微信支付流水
 * </p>
 *
 * @author liangyongtong
 * @since 2020-09-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_wx_pay_payment_flow")
public class OrderWxPayPaymentFlow extends IdEntity {

    private static final long serialVersionUID = -4620007935411743290L;
    /**
     * 订单支付来源
     */
    private String origin;

    /**
     * 支付业务单号：每发起一次新的支付都会生成一个新的
     */
    private String businessCode;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 支付方式： 支付方式: WX 微信 ALIPAY 支付宝
     */
    private String payWay;

    /**
     * 支付金额
     */
    private BigDecimal payAmount;

    /**
     * openid
     */
    private String openid;

    /**
     * 支付状态：PAYING 支付中 INVALID 失效 COMPLETE 完成
     */
    private String status;

    /**
     * 支付单完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 支付单失效时间,单位分钟,最少5分钟,默认 120分
     */
    private Integer invalidTime;

    /**
     * 支付单创建时间
     */
    private LocalDateTime createTime;


    @TableField(exist = false)
    private String wxTransactionId;

    @TableField(exist = false)
    private String wxTradeState;

}
