package com.rocogz.syy.order.dto.jms;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.dto.goods.CreateOrderModeEnum;
import com.rocogz.syy.order.entity.goods.GoodsOrder;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 支付成功推送调用：
 * （1）碎屏险,手机延保服务支付结果通知到三星生活助手（线上模式）
 * （2）碎屏险,手机延保服务支付结果通知到三星生活助手（线下模式）
 * （3）管家服务商品 推送券信息 到三星
 * @author zhangmin
 * @date 2020/11/16
 */
@Setter @Getter
public class NotifyPayResultToSamsungMsg {

    //失败后 是第几次尝试推送,不包括第一次
    private Integer retryTimes;

    /**
     * 碎屏险/手机延保服务 订单创建模式
     */
    private CreateOrderModeEnum createMode;

    /**
     * 是否管家服务商品
     */
    private Boolean butlerService;

    /**
     * 我们积分商城订单号
     */
    private String orderCode;

    /**
     *  三星订单号, 券码
     */
    private String coupon;

    /**
     * 订单类型,Coupon类型：DI-碎屏险，EW-延保，QY-爱奇艺， GIFT-礼品兑换，ALL-多类型合并支付
     */
    private String type;

    /**
     * 三星会员ID
     */
    private String memID;

    /**
     * 会员uid
     */
    private String unionId;

    /**
     * 支付单号,可以传入积分商城的订单号
     */
    private String tranID;


    /**
     * 支付现金(无现金支付为0)
     */
    private String payCash;

    /**
     * 支付积分(无积分支付为0)
     */
    private String payPoint;

    /**
     * 是否分期: Y-分期，N-不分期
     */
    private String payStageYN;

    /**
     * 分期期数，如分期此参数必填
     */
    private String payStageNum;

    //以下字段是管家服务商品 券信息同步字段
    private String mobileModel;
    private LocalDateTime createTime;

    //管家服务 电池券/后壳券 有效开始日期
    private LocalDate couponStartDate;
    //管家服务 电池券/后壳券 有效结束日期
    private LocalDate couponEndDate;

    private String imei;

    //支付完成时间 线下模式 需要此时间
    private LocalDateTime payfinishTime;

    public static NotifyPayResultToSamsungMsg valueOf(GoodsOrder goodOrder) {
        NotifyPayResultToSamsungMsg payResultMsg = new NotifyPayResultToSamsungMsg();
        payResultMsg.setCreateMode(goodOrder.getCreateMode());
        payResultMsg.setPayfinishTime(goodOrder.getPayFinishTime());

        payResultMsg.setUnionId(goodOrder.getUnionId());

        payResultMsg.setCoupon(goodOrder.getSamsungCouponCode());
        payResultMsg.setType(goodOrder.getSamsungCouponType());
        payResultMsg.setOrderCode(goodOrder.getOrderCode());
        payResultMsg.setTranID(goodOrder.getOrderCode());
        payResultMsg.setMemID(goodOrder.getSamsungMemId());
        //三星支付现金单位是：分
        double payCash = goodOrder.getTotalCash().doubleValue() *100;
        payResultMsg.setPayCash(String.valueOf((int)payCash));
        payResultMsg.setPayPoint(String.valueOf(goodOrder.getTotalCent().intValue()));

        payResultMsg.setMobileModel(goodOrder.getMobileModel());
        payResultMsg.setCreateTime(goodOrder.getCreateTime());
        payResultMsg.setCouponStartDate(goodOrder.getCouponStartDate());
        payResultMsg.setCouponEndDate(goodOrder.getCouponEndDate());
        payResultMsg.setImei(goodOrder.getImei());

        payResultMsg.setButlerService(goodOrder.getButlerService());


        payResultMsg.setRetryTimes(goodOrder.getNotifyRetryTimes());

        payResultMsg.setPayStageYN("N");

        if(OrderConstant.DictPayWay.HBPCREDIT.equals(goodOrder.getCashPayWay()) && goodOrder.getHbFqNum()!=null && goodOrder.getHbFqNum()>0) {
            payResultMsg.setPayStageYN("Y");
            payResultMsg.setPayStageNum(String.valueOf(goodOrder.getHbFqNum()));
        }


        return payResultMsg;
    }





}
