package com.rocogz.syy.order.entity.orders;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.rocogz.syy.order.constant.OrderConstant.DictPayStatus;
import com.rocogz.syy.order.util.ArithUtil;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 支付单
 * </p>
 * @author zhangmin
 * @since 2020-04-26
 */
@Setter @Getter @Accessors(chain = true)
public class OrderPayment extends BaseUserInfo {

    /**
     * 支付单号
     */
    private String payCode;

    /**
     * 整体支付状态：待支付、部分支付、支付完成
     * @see DictPayStatus
     */
    private String payStatus;

    /**
     * 需要支付的积分
     */
    private BigDecimal payCent;

    /**
     * 需支付的现金金额
     */
    private BigDecimal payAmt;

    /**
     * 已成功支付现金金额
     */
    private BigDecimal successAmt;

    /**
     * 已成功支付的积分
     */
    private BigDecimal successCent;

    /**
     * 支付描述：如：购买1本书
     */
    private String description;

    /**
     * 支付完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;

    /**
     * 修改人
     */
    private String updateUser;

    //支付记录列表
    @TableField(exist = false)
    private List<OrderPaymentRecord> recordList;

    // 以下是方便页面显示
    private transient String payStatusLabel;


    public void addRecord(OrderPaymentRecord record) {
        if(record == null) {
            return;
        }
        if(recordList ==null) {
            recordList = Lists.newArrayList();
        }
        recordList.add(record);
    }


    /**
     * 获得 待支付金额
     * @return
     */
    public BigDecimal getUnpayAmt() {
        if(payAmt == null || successAmt==null) {
            return null;
        }

        if(payAmt.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }

        return ArithUtil.roundToBigDecimal(ArithUtil.bigDecimalSubtract(payAmt,successAmt),2);
    }


    /**
     * 获得 待支付积分
     * @return
     */
    public BigDecimal getUnpayCent() {
        if(payCent == null || successCent==null) {
            return null;
        }

        if(payCent.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return  ArithUtil.roundToBigDecimal(ArithUtil.bigDecimalSubtract(payCent,successCent),2);
    }


    public String getFmtPayAmt() {
        if(payAmt == null) {
            return StringUtils.EMPTY;
        }

        return ArithUtil.getNoSymbolCurrency(payAmt.doubleValue());
    }


    public String getFmtSuccessAmt() {
        if(successAmt == null) {
            return StringUtils.EMPTY;
        }
        return ArithUtil.getNoSymbolCurrency(successAmt.doubleValue());
    }


}
