package com.rocogz.syy.order.dto.goods;

import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 充值结果更新Dto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/8/19 17:28</dd>
 * <dd>@author：zhangmin</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class DepositResultDto {


    //我们的订单号
    private String orderCode;

    /**
     * 我们的充值状态
     * @see OrderConstant.DictDepositStatus
     */
    private String depositStatus;

    /**
     * 上海宸运对接方充值状态
     */
    private String chenYunDepositStatus;


    //调用充值接口失败原因
    private String failReason;

    //是第几次尝试
    private Integer retryTimes;


    //更新时间或 最后尝试时间
    private LocalDateTime  updateTime;

}
