package com.rocogz.syy.order.entity.after;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.order.entity.orders.BaseUserInfo;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:这家伙很懒 </dd>
 * <dd>@date: 2020/10/26</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@TableName("order_after")
@Setter
@Getter
@Accessors(chain = true)
public class OrderAfter extends BaseUserInfo {
    /**
     * 售后单号
     */
    private String afterCode;

    /**
     *售后单的来源：前台用户创建，后台创建
     */
    private String afterSource;

    /**
     * 三星会员Id号
     */
    private String samsungMemId;

    /**
     * 会员姓名
     */
    private String userName;

    /**
     * 售后类型：退货，换货，仅退款
     */
    private String afterType;

    /**
     * 售后原因
     */
    private String afterReason;

    /**
     * 售后单状态
     */
    private String afterStatus;

    /**
     * 申请的退款金额
     */
    private BigDecimal refundApplyTotalCash;

    /**
     * 申请的退款积分
     */
    private BigDecimal refundApplyTotalPoint;

    /**
     * 本次已退款的总现金
     */
    private BigDecimal refundTotalCash;

    /**
     * 本次已退款总积分
     */
    private BigDecimal refundTotalPoint;

    /**
     * 退款现金状态：无需，待退款，退款成功，退款异常
     */
    private String refundCashStatus;

    /**
     * 退款现金状态：无需，待退款，退款成功，退款异常
     */
    private String refundPointStatus;

    /**
     * 审核状态:待审核，通过，不通过
     */
    private String auditStatus;
    /**
     * 审核人
     */
    private String auditUser;
    /**
     * 审核时间
     */
    private LocalDateTime auditTime;
    /**
     * 审核结果
     */
    private String auditResult;

    /**
     * 退货的快递公司名称
     */
    private String returnLogisticsName;

    /**
     * 退货的快递物流单号
     */
    private String returnLogisticsNo;

    /**
     * 退货物流的用户提交时间
     */
    private LocalDateTime returnLogisticsSubmitTime;

    /**
     * 换货的快递公司名称
     */
    private String deliveryLogisticsName;

    /**
     * 换货的物流单号
     */
    private String deliveryLogisticsNo;

    /**
     * 换货物流的提交时间
     */
    private LocalDateTime deliveryLogisticsSubmitTime;

    /**
     * 拒绝受理原因
     */
    private String refuseReason;

    /**
     * 拒绝受理时间
     */
    private LocalDateTime refuseTime;

    /**
     * 售后单据完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     *更新人
     */
    private String updateUser;

    /**
     * 下单来源平台编号，如：SYY
     * 该平台码来源于 基础服务系统中：basic_docking_platform表
     */
    @TableField(exist = false)
    private String platformCode;

    /**
     * 下单渠道：车主端，商户端，管理后台,接口调用
     *
     * @see OrderConstant.DictChannel
     */
    @TableField(exist = false)
    private String channel;



    /**
     * 虽然分成了多个,但后台展示的时候是按商品维度展示
     */
    @TableField(exist = false)
    private OrderAfterGoods afterGoods;


    /**
     * 售后单附件
     */
    @TableField(exist = false)
    public List<OrderAfterAttachment> afterAttachmentList;

    /**
     * 售后单的处理节点
     */
    @TableField(exist = false)
    public List<OrderAfterProcessRecord> afterProcessRecordList;



}
