package com.rocogz.syy.order.dto.jms;

import com.rocogz.syy.order.dto.goods.CreateOrderModeEnum;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * 碎屏险, 手机延保服务,  或管家服务订单  更新状态 给三星
 * @author zhangmin
 * @date 2020/11/16
 */
@Setter @Getter
public class UpdateStatusToSamsungMsg {

    //碎屏险 创建模式
    private CreateOrderModeEnum createMode;

    //是否是管家服务商品
    private Boolean butlerService;

    //我们积分商城的订单号
    private String orderCode;

    private String imei;

    //三星订单号或 couponCode
    private String couponCode;

    //维修码
    private String maintainCode;

    /**
     * （1）线下碎屏险 状态同步：订单状态: IV-已开票,  RP-已退款
     *  (2) 管家服务 状态同步：状态： A-购买 C-已取消  R-退货  U-已使用
    */
    private String samsungStatus;

    //更新日期，开票日期、退货日期
    private LocalDateTime updateDate;
}
