package com.rocogz.syy.order.entity.orders;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.constant.OrderSegmentEnum;
import com.rocogz.syy.order.dto.invoice.SubmitInvoiceParamDto;
import com.rocogz.syy.order.entity.goods.GoodsOrder;
import com.rocogz.syy.order.entity.goods.GoodsOrderDeliveryAddress;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 订单主信息表
 * </p>
 *
 * @author zhangmin
 * @since 2020-04-26
 */
@TableName("order_sale_order")
@Setter
@Getter
@Accessors(chain = true)
public class SaleOrder extends BaseUserInfo {

    private static final long serialVersionUID = 1L;

    /**
     * 订单类型编号：商品订单，福袋订单
     *
     * @see OrderConstant.DictOrderType
     */
    private String orderType;

    /**
     * 下单来源平台编号，如：SYY
     * 该平台码来源于 基础服务系统中：basic_docking_platform表
     * @see OrderConstant#DICT_PLATFORM_CODE_CENT_MALL
     */
    private String platformCode;

    /**
     * 订单划区枚举,根据菜单划分
     */
    private OrderSegmentEnum segment;

    /**
     * 下单渠道
     *
     * @see OrderConstant.UserVisitChannel
     */
    private String channel;

    /**
     * 主订单状态
     * @see OrderConstant.DictOrderStatus
     */
    private String orderStatus;


    /**
     * admin端 申请取消功能
     * 如果订单状态是 "待发货",可以发起"申请取消订单"功能，如果该申请审批通过后, 则可以管理员可以点击"取消订单"按钮
     * 取消订单后,状态变成已取消，并退积分，退款，如果是管家服务订单，还要同步取消状态到三星
     * @see OrderConstant.DictApplyStatus
     */
    private String cancelApplyStatus;

    /**
     * 需支付订单现金金额[现金部分]
     */
    private BigDecimal totalCash;

    /**
     * 需支付订单积分 [积分部分]
     */
    private BigDecimal totalCent;

    /**
     * 支付平台收取的 支付现金金额手续费
     */
    private BigDecimal cashFee;


    /**
     * 商品订单支付模式 (POINT:积分;  CASH:现金; POINT_AND_CASH:积分+现金)
     * @see com.rocogz.syy.order.constant.OrderConstant.DictGoodsOrderPayWay
     */
    private String payWay;


    /**
     * 最终成功支付的 现金使用的支付方式：微信/支付宝
     * @see com.rocogz.syy.order.constant.OrderConstant.DictPayWay
     */
    private String cashPayWay;

    /**
     * 花呗分期
     */
    private Integer hbFqNum;


    /**
     * 福袋商品编号
     */
    private String suiteGoodCode;

    /**
     * 福袋sku编号
     */
    private String suiteSkuCode;

    /**
     * 福袋商品名称
     */
    private String suiteGoodName;

    /**
     * 福袋结算价
     */
    private BigDecimal suiteSettlePrice;

    /**
     * 福袋服务费率
     */
    private BigDecimal suiteServiceRate;

    /**
     * 福袋商品图片Url
     */
    private String  suitePictureUrl;


    /**
     * 取消订单时间
     */
    private LocalDateTime cancelTime;

    /**
     * 订单过期时间：例如三星碎屏险订单的 支付过期时间
     */
    private LocalDateTime expireTime;

    /**
     * 是否被逻辑删除,即是否被会员自己删除了
     */
    private Boolean deleted;

    //支付单
    @TableField(exist = false)
    private OrderPayment payment;


    /**
     * 商品订单信息[商品订单 专有]
     */
    @TableField(exist = false)
    private GoodsOrder goodsOrder;

    /**
     * 福袋订单包含的子订单
     */
    @TableField(exist = false)
    private List<GoodsOrder> orderItemList;

    /**
     * 收货地址信息[非虚拟商品才有收货地址]
     */
    @TableField(exist = false)
    private GoodsOrderDeliveryAddress goodsOrderDeliveryAddress;

    //创建订单 用户输入的发票信息
    @TableField(exist = false)
    private SubmitInvoiceParamDto invoiceDto;

    //支付完成时间
    private transient LocalDateTime payFinishTime;

    /**
     * =====> 以下都是为了页面展示数据用的
     */
    private transient String orderTypeLabel;
    private transient String statusLabel;
    private transient String channelLabel;
    //平台名称
    private transient String platformName;


    //hhl增加,为了直观判断是否能再次售后
    //adminSearch 售后操作 按钮判断
    @TableField(exist = false)
    private String afterCode;

    //是否允许售后服务[是否能看见售后按钮]
    private transient Boolean afterSaleAllowed;
}
