package com.rocogz.syy.order.dto.invoice;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/12/1 下午3:19</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class SubmitInvoiceParamDto {

    //前端订单结算页 开发票,补开发票需要的参数
    private String applyCode;
    private Boolean hasInvoice;

    /**
     * 开票的订单编号信息，用于将开票申请编号更新到订单表中
     */
    private List<String> orderCodes;

    /**
     * 开票会员的union id
     */
    private String unionId;

    /**
     * 发票类型
     * {@link com.rocogz.syy.order.constant.OrderConstant.OrderInvoiceType}
     */
    private String invoiceType;

    /**
     * 抬头类型
     * {@link com.rocogz.syy.order.constant.OrderConstant.OrderInvoiceTitleType}
     */
    private String titleType;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 发票税号
     */
    private String invoiceNo;

    /**
     * 开户银行
     */
    private String bankName;

    /**
     * 银行账户
     */
    private String bankAccount;

    /**
     * 企业电话
     */
    private String companyPhone;

    /**
     * 企业地址
     */
    private String companyAddress;

    /**
     * 发票的接收方式
     * {@link com.rocogz.syy.order.constant.OrderConstant.OrderInvoiceReceiveWay}
     */
    private String receiveWay;

    /**
     * 接收发票的手机号R
     */
    private String mobile;

    /**
     * 接收发票的电子邮箱
     */
    private String email;

    /**
     * 开票金额
     */
    private BigDecimal invoiceAmount;
}
