package com.rocogz.syy.order.dto.after;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:后台售后申请单listVO对象 </dd>
 * <dd>@date: 2020/10/26</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class AdminAfterOrderListVo {

    /**
     * 订单编号
     */

    private String orderCode;

    /**
     * 会员编号，即车主编号
     */
    private String userCode;

    /**
     * 会员openid
     */
    private String userOpenid;

    /**
     * 会员手机号
     */
    private String userMobile;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 售后单号
     */
    private String afterCode;

    /**
     *售后单的来源：前台用户创建，后台创建
     */
    private String afterSource;

    /**
     * 三星的会员ID
     */
    private String samsungUserId;

    /**
     * 会员姓名
     */
    private String userName;

    /**
     * 售后类型：退货，换货，仅退款
     */
    private String afterType;

    /**
     * 售后原因
     */
    private String afterReason;

    /**
     * 售后单状态
     */
    private String afterStatus;

    /**
     * 本次已退款
     */
    private BigDecimal refundTotalCash;

    /**
     * 本次退款的总积分
     */
    private BigDecimal refundTotalPoint;

    /**
     * 退款现金状态：无需，待退款，退款成功，退款异常
     */
    private String refundCashStatus;

    /**
     * 退款现金状态：无需，待退款，退款成功，退款异常
     */
    private String refundPointStatus;

    /**
     * 审核状态:待审核，通过，不通过
     */
    private String auditStatus;

    /**
     * 退货的快递公司编码
     */
    private String returnLogisticsCode;

    /**
     * 退货的快递公司名称
     */
    private String returnLogisticsName;

    /**
     * 退货的快递物流单号
     */
    private String returnLogisticsNo;

    /**
     * 退货的入库状态：无需，待入库，良品入库，次品入库，拒收
     */
    private String returnInStatus;

    /**
     * 商品的入库备注
     */
    private String returnInMemo;

    /**
     * 商品的入库时间
     */
    private LocalDateTime returnInTime;

    /**
     * 商品配送状态
     */
    private String  proDeliveryStatus;

    /**
     * 换货的快递公司编码
     */
    private String deliveryLogisticsCode;

    /**
     * 换货的快递公司名称
     */
    private String deliveryLogisticsName;

    /**
     * 换货的物流单号
     */
    private String deliveryLogisticsNo;

    /**
     * 换货发货时间
     */
    private LocalDateTime proDeliveryTime;

    /**
     * 售后单据完成时间
     */
    private LocalDateTime finishTime;
    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     *更新人
     */
    private LocalDateTime updateUser;

    /**
     * 商品编码
     */
    private String goodsCode;
    /**
     * SKU编码
     */
    private String  skuCode;

    /**
     * 商品SKU名称，带有SKU属性
     */
    private String  skuName;

    /**
     * 商品的展示图片
     */
    private String goodsPictureUrl;

    /**
     * 申请售后数量
     */
    private Integer afterNum;

    /**
     * 申请的退款金额
     */
    private BigDecimal refundApplyTotalCash;

    /**
     * 申请的退款积分
     */
    private BigDecimal refundApplyTotalPoint;

}
