package com.rocogz.syy.order.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.order.constant.OrderStatisOption;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 *  商户端 订单销量 统计结果
 * @author zhangmin
 * @date 2020/5/21
 */
@Setter @Getter @ToString
public class OrderSummaryStatistic {

    /**
     * 统计参数
     */
    private OrderStatisOption statisOption;

    /**
     * 订单数量
     */
    private Integer orderNum;

    /**
     * 订单总金额
     */
    private BigDecimal totalAmt;


    @JsonIgnore
    public String getStatistMapKey() {
        StringBuffer keyBuf = new StringBuffer();
        if(StringUtils.isNotEmpty(statisOption.getDepositMobile())) {
            keyBuf.append(statisOption.getDepositMobile());
        }

        if(StringUtils.isNotEmpty(statisOption.getUserCode())) {
            keyBuf.append(statisOption.getUserCode());
        }

        keyBuf.append("-").append( statisOption.getTimeRange().name());

        return keyBuf.toString();

    }

}
