package com.rocogz.syy.order.dto.goods;

import com.rocogz.syy.order.constant.CreateOrderModeEnum;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.constant.OrderSegmentEnum;
import com.rocogz.syy.order.dto.invoice.SubmitInvoiceParamDto;
import com.rocogz.syy.order.entity.goods.GoodsOrderDeliveryAddress;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;
import java.util.List;

/**
 * 创建商品订单 Dto
 * @author ranxiangfu
 * @date 2020/8/19
 */
@Setter @Getter
@Accessors(chain = true)
public class CreateGoodsOrderDto extends SamsungMemberInfoDto {

    private OrderSegmentEnum segment;

    /**
     * 订单类型：
     * @see OrderConstant.DictOrderType
     */
    private String orderType;

    /**
     * 订单编号 [如果是外部生成订单编号，则传入此参数]
     */
    private String orderCode;

    /**
     * 下单来源平台编号，如：三星积分商城  [必传]
     * @see OrderConstant#DICT_PLATFORM_CODE_CENT_MALL
     */
    @NotEmpty
    private String platformCode;

    /**
     * 下单渠道：WAP，PC，管理后台,接口调用 [必传]
     *
     * @see OrderConstant.UserVisitChannel
     */
    @NotEmpty
    private String channel;


    /**
     * 商品订单支付模式 (POINT:积分;  CASH:现金; POINT_AND_CASH:积分+现金)
     * @see com.rocogz.syy.order.constant.OrderConstant.DictGoodsOrderPayWay
     */
    private String payWay;


    /**
     * 现金使用的支付方式：微信/支付宝
     * @see com.rocogz.syy.order.constant.OrderConstant.DictPayWay
     */
    private String cashPayWay;

    /**
     * 花呗分期数
     */
    private Integer hbFqNum;

    /**
     * 花呗分期 分期手续费
     */
    private BigDecimal hbFqFee;

    /**
     * 订单总计：需支付订单现金金额[现金部分]
     */
    private BigDecimal totalCash = BigDecimal.ZERO;

    /**
     * 订单总计：需支付订单积分 [积分部分]
     */
    private BigDecimal totalCent = BigDecimal.ZERO;

    /**
     * 支付平台收取的 支付现金金额手续费
     */
    private BigDecimal cashFee = BigDecimal.ZERO;


    /**
     * 福袋商品编号
     */
    private String suiteGoodCode;

    /**
     * 福袋sku编号
     */
    private String suiteSkuCode;

    /**
     * 福袋商品名称
     */
    private String suiteGoodName;

    /**
     * 福袋结算价
     */
    private BigDecimal suiteSettlePrice;

    /**
     * 福袋市场价格
     */
    private BigDecimal suiteMarketPrice;

    /**
     * 福袋服务费率
     */
    private BigDecimal suiteServiceRate;

    /**
     * 福袋商品供应商编号
     */
    private String suiteSupplierCode;

    /**
     * 福袋商品供应商名称
     */
    private String suiteSupplierName;

    /**
     * 福袋商品图片Url
     */
    private String  suitePictureUrl;


    /**
     * 包含的子订单列表
     */
    private List<GoodOrderItemDto> itemList;


    //三星订单 支付过期时间
    private String payExpireTime;

    /**
     * 碎屏险/手机延保服务:下单模式
     */
    private CreateOrderModeEnum createMode;

    /**
     * 收货地址信息
     */
    private GoodsOrderDeliveryAddress deliveryAddress;


    //线下碎屏险 发票信息
    private SubmitInvoiceParamDto invoiceDto;

}

