package com.rocogz.syy.order.dto.settle.order;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDate;

/**
 * <dl>
 * <dd>Description:结算订单列表查询请求DTO </dd>
 * <dd>@date: 2021/04/20</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class SettleOrderSearchDto {

    /**
     * 结算单编号
     */
    private String settleOrderCode;

    /**
     * 商品供应商编号
     */
    private String supplierCode;

    /**
     * 结算单类型: 普通商品、特殊商品
     */
    private String settleOrderType;

    /**
     * 供应商结算状态
     */
    private String supplierSettleStatus;

    /**
     * 供应商结算日期查询开始
     */
    private String supplierSettleDateStart;

    /**
     * 供应商结算日期查询结束
     */
    private String supplierSettleDateEnd;

    /**
     * 运营商结算状态
     */
    private String operatorSettleStatus;

    /**
     * 运营商结算日期查询开始
     */
    private LocalDate operatorSettleDateStart;

    /**
     * 运营商结算日期查询结束
     */
    private LocalDate operatorSettleDateEnd;

    /**
     * 分页
     */
    private Integer limit = 20;
    /**
     * 当前第几页
     */
    private Integer page = 1;

    /**
     * 是否需要导出
     */
    private Boolean export = Boolean.FALSE;


}
