package com.rocogz.syy.order.entity.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 结算单
 * </p>
 *
 * @author zhangmin
 * @since 2021-04-20
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderSettleOrder extends UserTimeEntity {

    /**
     * 结算单编号
     */
    @UniqueField
    private String settleOrderCode;

    /**
     * 结算单类型: 普通商品、特殊商品
     * @see OrderConstant.DictSettleOrderType
     */
    private String settleOrderType;

    /**
     * 商品供应商编号
     */
    private String supplierCode;

    /**
     * 供应商结算状态
     * @see OrderConstant.DictSettleStatus
     */
    private String supplierSettleStatus;

    /**
     * 供应商结算日期
     */
    private LocalDate supplierSettleDate;

    /**
     * 运营商结算状态
     * @see OrderConstant.DictSettleStatus
     */
    private String operatorSettleStatus;

    /**
     * 运营商结算日期
     */
    private LocalDate operatorSettleDate;

    /**
     * 订单数量
     */
    private Integer orderNum;

    /**
     * 结算订单文件【特殊商品专有字段】
     */
    private String orderFilePath;

    /**
     * 商品实际金额合计=商品结算价*数量
     */
    private BigDecimal totalRealAmount;

    /**
     * 实付现金合计
     */
    private BigDecimal totalCashAmount;

    /**
     * 实付积分合计
     */
    private BigDecimal totalCentAmount;

    /**
     * 实物商品物流费合计
     */
    private BigDecimal totalLogisticFee;

    /**
     * 现金支付通道费合计
     */
    private BigDecimal totalCashPayFee;

    /**
     * 花呗分期手续费合计
     */
    private BigDecimal totalHbFqFee;

    /**
     * 现金支付相关手续费= total_cash_pay_fee+total_hb_fq_fee
     */
    private BigDecimal totalActuaryFee;

    /**
     * 实际精算费用= total_real_amount-total_cash_amount
     */
    private BigDecimal totalActuaryAmount;

    /**
     * 需要精算费用=total_actuary_amount+ total_actuary_fee+ total_logistic_fee
     */
    private BigDecimal needActuaryAmount;

    /**
     * 结算单备注
     */
    private String remark;

}
