package com.rocogz.syy.order.entity.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 结算单的结算信息
 * </p>
 *
 * @author zhangmin
 * @since 2021-04-20
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderSettleInfo extends UserTimeEntity {

    /**
     * 结算号
     */
    @UniqueField
    private String settleCode;

    /**
     * 结算单号
     * @see OrderSettleOrder#settleOrderCode
     */
    private String settleOrderCode;

    /**
     * 结算主体类型：供应商、运营商
     * @see OrderConstant.DictSettleSubjectType
     */
    private String settleSubjectType;

    /**
     * 结算状态
     * @see OrderConstant.DictSettleStatus
     */
    private String settleStatus;

    /**
     * 结算日期
     */
    private LocalDate settleDate;

    /**
     * 付款方
     */
    private String payCompany;

    /**
     * 付款经办人
     */
    private String payUser;

    /**
     * 收款方
     */
    private String receiveCompany;

    /**
     * 收款经办人
     */
    private String receiveUser;

    /**
     * 结算凭证文件路径
     */
    private String credentialFilePath;

    /**
     * 结算备注
     */
    private String remark;

}
