package com.rocogz.syy.order.dto.goods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.constant.OrderSegmentEnum;
import com.rocogz.syy.order.constant.SearchSuiteOrderTypeNum;
import com.rocogz.syy.order.dto.AdminBaseSearchDto;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 管理后台-> 商品订单 搜索 条件
 * @author ranxiangfu
 * @date 2020/8/18
 */
@Data
public class GoodsAdminSearchParamDto extends AdminBaseSearchDto {

    public GoodsAdminSearchParamDto() {
        setOrderType(OrderConstant.DictOrderType.GOODS_ORDER);
        setSegment(OrderSegmentEnum.GOOD);
    }

    private String addressee;
    private String addresseeMobile;
    //商品编号/福袋商品编号
    private String goodsCode;
    private String erpCode;
    private String skuCode;

    //搜索福袋订单类型
    @JsonIgnore
    private SearchSuiteOrderTypeNum searchSuiteType;

    private String goodsName;
    private String goodsSupplierCode;
    private String expressDeliveryName;
    private String expressDeliveryNumber;
    private String payWay;
    private String finishStartTime;
    private String finishEndTime;
    private Boolean virtualGoods;

    //按照虚拟商品类型搜索
    private String virtualType;

    private Boolean changeStatus2Delivered;

    /**
     * 充值订单的 充值状态
     */
    private String depositStatus;

    /**
     * 三星会员名字
     */
    private String samsungMemName;

    private List<String> supplierCodeList;


    @JsonIgnore
    public String getSamsungMemNameLike() {
        if(StringUtils.isEmpty(samsungMemName)) {
            return null;
        }

        return StringUtils.wrap(samsungMemName,"%");
    }


    @JsonIgnore
    public String getGoodsNameLike() {
        if(StringUtils.isEmpty(goodsName)) {
            return null;
        }

        return StringUtils.wrap(goodsName,"%");
    }



}
