/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.dto.settle.order;

import com.rocogz.syy.order.entity.goods.GoodsOrder;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import com.rocogz.syy.order.util.ArithUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.BeanUtils;

public class SettleSearchOrderItemResultDto {
    private Integer settleOrderItemId;
    private String orderCode;
    private String orderItemCode;
    private String goodCode;
    private String erpCode;
    private String goodName;
    private Boolean virtual;
    private String virtualType;
    private String virtualTypeLabel;
    private String payWay;
    private String payWayLabel;
    private Boolean samsungPrefecture;
    private BigDecimal cashAmount;
    private BigDecimal centAmount;
    private BigDecimal realAmount;
    private BigDecimal cashPayFee;
    private BigDecimal hbFqFee;
    private BigDecimal taxRate;
    private BigDecimal logisticFee;
    private BigDecimal actuaryFee;
    private String cashPayWay;
    private BigDecimal realSettlementPrice;
    private Integer quantity;
    private String payCredential;
    private String samsungMobile;
    private String samsungMemName;
    private LocalDateTime createTime;
    private LocalDateTime finishTime;
    private String depositStatus;
    private String depositStatusLabel;
    private String status;
    private String statusLabel;
    private String supplierSettleStatus;
    private String supplierSettleStatusLabel;
    private String operatorSettleStatus;
    private String operatorSettleStatusLabel;

    public LocalDate getCreateDate() {
        if (this.createTime == null) {
            return null;
        }
        return this.createTime.toLocalDate();
    }

    public String getVirtualType() {
        if (Boolean.FALSE.equals(this.virtual)) {
            return "real";
        }
        return this.virtualType;
    }

    public boolean isHbfq() {
        return "HBPCREDIT".equals(this.cashPayWay);
    }

    public BigDecimal getActuaryAmount() {
        return ArithUtil.bigDecimalSubtract(this.realAmount, this.cashAmount);
    }

    public BigDecimal getDeductCashAmount() {
        return ArithUtil.bigDecimalSubtract(this.cashAmount, this.actuaryFee);
    }

    public BigDecimal getNeedActuaryAmount() {
        double needActuaryAmt = this.getActuaryAmount().doubleValue() + this.actuaryFee.doubleValue() + Optional.ofNullable(this.logisticFee).orElse(BigDecimal.ZERO).doubleValue();
        return ArithUtil.roundToBigDecimal(needActuaryAmt, 3);
    }

    public static SettleSearchOrderItemResultDto valueOf(SaleOrder order) {
        GoodsOrder goodOrder = order.getGoodsOrder();
        SettleSearchOrderItemResultDto resultDto = new SettleSearchOrderItemResultDto();
        BeanUtils.copyProperties((Object)((Object)goodOrder), (Object)resultDto);
        if (resultDto.getLogisticFee() == null) {
            resultDto.setLogisticFee(BigDecimal.ZERO);
        }
        double realAmt = Optional.ofNullable(goodOrder.getRealSettlementPrice()).orElse(BigDecimal.ZERO).doubleValue() * (double)goodOrder.getQuantity().intValue();
        resultDto.setRealAmount(ArithUtil.roundToBigDecimal(realAmt, 3));
        resultDto.setPayWay(order.getPayWay());
        resultDto.setCashPayWay(order.getCashPayWay());
        resultDto.setActuaryFee(order.getTotalCashFee());
        resultDto.setCashAmount(goodOrder.getTotalCash());
        resultDto.setCentAmount(goodOrder.getTotalCent());
        resultDto.setHbFqFee(Optional.ofNullable(order.getHbFqFee()).orElse(BigDecimal.ZERO));
        resultDto.setCashPayFee(order.getCashFee());
        return resultDto;
    }

    public void setSettleOrderItemId(Integer settleOrderItemId) {
        this.settleOrderItemId = settleOrderItemId;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public void setOrderItemCode(String orderItemCode) {
        this.orderItemCode = orderItemCode;
    }

    public void setGoodCode(String goodCode) {
        this.goodCode = goodCode;
    }

    public void setErpCode(String erpCode) {
        this.erpCode = erpCode;
    }

    public void setGoodName(String goodName) {
        this.goodName = goodName;
    }

    public void setVirtual(Boolean virtual) {
        this.virtual = virtual;
    }

    public void setVirtualType(String virtualType) {
        this.virtualType = virtualType;
    }

    public void setVirtualTypeLabel(String virtualTypeLabel) {
        this.virtualTypeLabel = virtualTypeLabel;
    }

    public void setPayWay(String payWay) {
        this.payWay = payWay;
    }

    public void setPayWayLabel(String payWayLabel) {
        this.payWayLabel = payWayLabel;
    }

    public void setSamsungPrefecture(Boolean samsungPrefecture) {
        this.samsungPrefecture = samsungPrefecture;
    }

    public void setCashAmount(BigDecimal cashAmount) {
        this.cashAmount = cashAmount;
    }

    public void setCentAmount(BigDecimal centAmount) {
        this.centAmount = centAmount;
    }

    public void setRealAmount(BigDecimal realAmount) {
        this.realAmount = realAmount;
    }

    public void setCashPayFee(BigDecimal cashPayFee) {
        this.cashPayFee = cashPayFee;
    }

    public void setHbFqFee(BigDecimal hbFqFee) {
        this.hbFqFee = hbFqFee;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public void setLogisticFee(BigDecimal logisticFee) {
        this.logisticFee = logisticFee;
    }

    public void setActuaryFee(BigDecimal actuaryFee) {
        this.actuaryFee = actuaryFee;
    }

    public void setCashPayWay(String cashPayWay) {
        this.cashPayWay = cashPayWay;
    }

    public void setRealSettlementPrice(BigDecimal realSettlementPrice) {
        this.realSettlementPrice = realSettlementPrice;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public void setPayCredential(String payCredential) {
        this.payCredential = payCredential;
    }

    public void setSamsungMobile(String samsungMobile) {
        this.samsungMobile = samsungMobile;
    }

    public void setSamsungMemName(String samsungMemName) {
        this.samsungMemName = samsungMemName;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setFinishTime(LocalDateTime finishTime) {
        this.finishTime = finishTime;
    }

    public void setDepositStatus(String depositStatus) {
        this.depositStatus = depositStatus;
    }

    public void setDepositStatusLabel(String depositStatusLabel) {
        this.depositStatusLabel = depositStatusLabel;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatusLabel(String statusLabel) {
        this.statusLabel = statusLabel;
    }

    public void setSupplierSettleStatus(String supplierSettleStatus) {
        this.supplierSettleStatus = supplierSettleStatus;
    }

    public void setSupplierSettleStatusLabel(String supplierSettleStatusLabel) {
        this.supplierSettleStatusLabel = supplierSettleStatusLabel;
    }

    public void setOperatorSettleStatus(String operatorSettleStatus) {
        this.operatorSettleStatus = operatorSettleStatus;
    }

    public void setOperatorSettleStatusLabel(String operatorSettleStatusLabel) {
        this.operatorSettleStatusLabel = operatorSettleStatusLabel;
    }

    public Integer getSettleOrderItemId() {
        return this.settleOrderItemId;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public String getOrderItemCode() {
        return this.orderItemCode;
    }

    public String getGoodCode() {
        return this.goodCode;
    }

    public String getErpCode() {
        return this.erpCode;
    }

    public String getGoodName() {
        return this.goodName;
    }

    public Boolean getVirtual() {
        return this.virtual;
    }

    public String getVirtualTypeLabel() {
        return this.virtualTypeLabel;
    }

    public String getPayWay() {
        return this.payWay;
    }

    public String getPayWayLabel() {
        return this.payWayLabel;
    }

    public Boolean getSamsungPrefecture() {
        return this.samsungPrefecture;
    }

    public BigDecimal getCashAmount() {
        return this.cashAmount;
    }

    public BigDecimal getCentAmount() {
        return this.centAmount;
    }

    public BigDecimal getRealAmount() {
        return this.realAmount;
    }

    public BigDecimal getCashPayFee() {
        return this.cashPayFee;
    }

    public BigDecimal getHbFqFee() {
        return this.hbFqFee;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public BigDecimal getLogisticFee() {
        return this.logisticFee;
    }

    public BigDecimal getActuaryFee() {
        return this.actuaryFee;
    }

    public String getCashPayWay() {
        return this.cashPayWay;
    }

    public BigDecimal getRealSettlementPrice() {
        return this.realSettlementPrice;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public String getPayCredential() {
        return this.payCredential;
    }

    public String getSamsungMobile() {
        return this.samsungMobile;
    }

    public String getSamsungMemName() {
        return this.samsungMemName;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public LocalDateTime getFinishTime() {
        return this.finishTime;
    }

    public String getDepositStatus() {
        return this.depositStatus;
    }

    public String getDepositStatusLabel() {
        return this.depositStatusLabel;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusLabel() {
        return this.statusLabel;
    }

    public String getSupplierSettleStatus() {
        return this.supplierSettleStatus;
    }

    public String getSupplierSettleStatusLabel() {
        return this.supplierSettleStatusLabel;
    }

    public String getOperatorSettleStatus() {
        return this.operatorSettleStatus;
    }

    public String getOperatorSettleStatusLabel() {
        return this.operatorSettleStatusLabel;
    }
}

