package com.rocogz.syy.order.dto;

import com.rocogz.syy.order.constant.OrderConstant.DictPayWay;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 订单 现金支付订单Dto
 * @author zhangmin
 * @date 2020/5/31
 */
@Setter @Getter
public class OrderCashPayDto {

    /**
     * 要支付的 车服订单号 [必须]
     */
    private String orderCode;

    /**
     * 第三方支付平台的支付单号或支付交易号 [必须]
     */
    private String payCode;

    /**
     * 支付的现金 金额 [必须]
     */
    private BigDecimal payAmt;

    /**
     * 现金支付方式：是微信支付,还是支付宝支付  [必须]
     * @see DictPayWay#WEIXIN
     */
    private String payWay;

    /**
     * 蚂蚁花呗分期支付方式=> 分期期数
     */
    private Integer hbFqNum;

}
