package com.rocogz.syy.order.constant.after;

import org.apache.ibatis.jdbc.Null;
import org.apache.logging.log4j.util.Strings;

/**
 * <dl>
 * <dd>Description:这家伙很懒 </dd>
 * <dd>@date: 2020/10/26</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
public class OrderAfterConstant {


    /**
     * 提现订单审核中心回调地址
     */
    public static final String AFTER_APPROVEMENT_CALL_BACK_URL = "/api/order/after/admin/afterApproveCallBlack";


    /**
     * 售后单的售后模式
     */
    public static class ConstantDataOrderAfterModel {
        /**
         * 整单售后
         */
        public final static String WHOLE="WHOLE";
        /**
         * 部分售后
         */
        public final static String PART="PART";

    }


    /**
     * 售后的商品类型
     */
    public static class ConstantDataOrderAfterProCate{
        /**
         * 正常的
         */
        public final static String NORMAL="NORMAL";
        /**
         * 套餐的主商品
         */
        public final static String SUITE_MAIN="SUITE_MAIN";

    }



    /**
     * 节点的用户操作类型
     */
    public static class ConstantDataOrderAfterNodeUserType{

        public final static String USER="USER";

        public final static String ADMIN="ADMIN";
    }


    /**
     * 售后的流程节点标示
     */
    public static class ConstantDataOrderAfterNode {

        /****************公共***************/
        /**
         * tip:您的售后申请提交成功
         */
        public final static String SUBMIT = "SUBMIT";
        public final static String SUBMIT_LABEL = "售后单提交";


        /**
         * tip:很抱歉您的售后申请未通过
         */
        public final static String REFUSE = "REFUSE";
        public final static String REFUSE_LABEL = "终止受理";


        /****************仅退款****************/

        /**
         * tip:您的退款审核已通过，等待退款中
         */
        public final static String REFUND_AUDIT_AGREE="REFUND_AUDIT_AGREE";
        public final static String REFUND_AUDIT_AGREE_LABEL="仅退款-审核通过";

        /**
         * 退款成功
         */
        public final static String REFUND_SUCCESS="REFUND_SUCCESS";
        public final static String REFUND_SUCCESS_LABEL="仅退款-成功";


        /****************换货******************/
        /**
         * tip: 同意您的售后申请，请将商品和原包装退回收到退货后为您换货.
         */
        public final static String EXCHANGE_AUDIT_AGREE = "EXCHANGE_AUDIT_AGREE";
        public final static String EXCHANGE_AUDIT_AGREE_LABEL = "换货申请审批通过";


        /**
         * tip:买家商品已寄回
         */
        public final static String EXCHANGE_USER_LOGISTICS_SUBMIT = "EXCHANGE_USER_LOGISTICS_SUBMIT";
        public final static String EXCHANGE_USER_LOGISTICS_SUBMIT_LABEL = "用户提交换货物流";

        /**
         * tip:卖家已收货，等待商家换货
         */
//        public final static String EXCHANGE_ADMIN_LOGISTICS_IN = "EXCHANGE_ADMIN_LOGISTICS_IN";
//        public final static String EXCHANGE_ADMIN_LOGISTICS_IN_LABEL = "换货退货已收货";

        /**
         * tip:已收到退回商品，换货商品已寄出请注意查收
         */
        public final static String EXCHANGE_ADMIN_LOGISTICS_OUT = "EXCHANGE_ADMIN_LOGISTICS_OUT";
        public final static String EXCHANGE_ADMIN_LOGISTICS_OUT_LABEL = "换货商品已发货";

        /**
         * tip:确认已收货
         */
        public final static String EXCHANGE_SUCCESS = "EXCHANGE_SUCCESS";
        public final static String EXCHANGE_SUCCESS_LABEL = "用户确认收货";


        /****************退货******************/
        /**
         * tip: 同意您的售后申请，请将商品和原包装退回收到退货后为您办理退款。
         */
        public final static String RETURN_AUDIT_AGREE = "RETURN_AUDIT_AGREE";
        public final static String RETURN_AUDIT_AGREE_LABEL = "退货申请审批通过";

        /**
         * tip:买家商品已寄回
         */
        public final static String RETURN_USER_LOGISTICS_SUBMIT = "RETURN_USER_LOGISTICS_SUBMIT";
        public final static String RETURN_USER_LOGISTICS_SUBMIT_LABEL = "退货用户提交退货物流";

        /**
         * tip:卖家已收货，等待退款中
         */
//        public final static String RETURN_ADMIN_LOGISTICS_IN = "RETURN_ADMIN_LOGISTICS_IN";
//        public final static String RETURN_ADMIN_LOGISTICS_IN_LABEL = "退货已收货";

        /**
         *退款已完成，退款金额%s。感谢您对三星积分商城的支持。
         */
        public final static String RETURN_SUCCESS="RETURN_SUCCESS";
        public final static String RETURN_SUCCESS_LABEL = "退货退款完成";


        /**
         * 不同节点需要加载的信息
         */
        public static String getNodeLoadDataType(String node){
            String info=Strings.EMPTY;

            switch (node) {
                case SUBMIT:
                    info = ConstantDataOrderAfterNodeLoadDataType.APPLY_INFO;
                    break;
                case EXCHANGE_AUDIT_AGREE:
                    info = ConstantDataOrderAfterNodeLoadDataType.RETURN_WAREHOUSE_INFO;
                    break;
                case EXCHANGE_USER_LOGISTICS_SUBMIT:
                    info = ConstantDataOrderAfterNodeLoadDataType.RETURN_LOGISTICS_INFO;
                    break;
                case EXCHANGE_ADMIN_LOGISTICS_OUT:
                    info = ConstantDataOrderAfterNodeLoadDataType.DELIVERY_LOGISTICS_INFO;
                    break;
                case RETURN_AUDIT_AGREE:
                    info = ConstantDataOrderAfterNodeLoadDataType.RETURN_WAREHOUSE_INFO;
                    break;
                case RETURN_USER_LOGISTICS_SUBMIT:
                    info = ConstantDataOrderAfterNodeLoadDataType.RETURN_LOGISTICS_INFO;
                    break;
                default:
                    info=ConstantDataOrderAfterNodeLoadDataType.NONE;

            }
            return info;
        }


        /**
         * 得到节点信息的二级小标题，就是两个 物流信息，退货信息 小标题
         * @param node
         * @return
         */
        public static String getNodeSecondTip(String node){
            String info=null;
            switch (node) {
                case EXCHANGE_AUDIT_AGREE:
                    info = "退货信息";
                    break;
                case EXCHANGE_ADMIN_LOGISTICS_OUT:
                    info = "物流信息";
                    break;
                case RETURN_AUDIT_AGREE:
                    info = "退货信息";
                    break;
            }
            return info;
        }


        /**
         * 获取到节点后，查看第一个节点的Node类型
         * @param node
         * @return
         */
        public static String getNodeCanAaction(String node){
            String info=ConstantDataOrderAfterNodeAction.NONE;
            switch (node) {
                case EXCHANGE_AUDIT_AGREE:
                    info = ConstantDataOrderAfterNodeAction.SUBMIT_LOGISTICS;
                    break;
                case RETURN_AUDIT_AGREE:
                    info = ConstantDataOrderAfterNodeAction.SUBMIT_LOGISTICS;
                    break;
                case EXCHANGE_ADMIN_LOGISTICS_OUT:
                    info = ConstantDataOrderAfterNodeAction.CONFIRM_DELIVERY_LOGISTICS;
                    break;

            }
            return info;
        }



    }

    /**
     * 此售后节点需要之行的动作，主要是商城端 两个 填写退货物流，确认收货
     */
    public static class ConstantDataOrderAfterNodeAction{
        /**
         * 没有动作
         */
        public final static String NONE="NONE";

        /**
         * 提交退货物流
         */
        public final static String SUBMIT_LOGISTICS="SUBMIT_LOGISTICS";

        /**
         * 确认收货
         */
        public final static String CONFIRM_DELIVERY_LOGISTICS="CONFIRM_DELIVERY_LOGISTICS";


    }

    /**
     * Node节点加载的数据类型,商城售后详情 节点信息加载的数据
     */
    public static class ConstantDataOrderAfterNodeLoadDataType{

        /**
         * 无需加载
         */
        public final static String NONE="NONE";

        /**
         * 申请信息
         */
        public final static String APPLY_INFO="APPLY_INFO";

        /**
         * 退货的仓库信息
         */
        public final static String RETURN_WAREHOUSE_INFO="RETURN_WAREHOUSE_INFO";

        /**
         * 退货物流信息
         */
        public final static String RETURN_LOGISTICS_INFO="RETURN_LOGISTICS_INFO";

        /**
         * 换货出库物流信息
         */
        public final static String DELIVERY_LOGISTICS_INFO="DELIVERY_LOGISTICS_INFO";

    }




    /**
     * 售后类型
     */
    public static class DictTypeOrderAfterType{
        public final static String ORDER_AFTER_TYPE="ORDER_AFTER_TYPE";
    }

    /**
     * 售后类型
     */
    public static class DictDataOrderAfterType{

        public final static String REFUND="REFUND";
        public final static String REFUND_LABEL="仅退款";

        public final static String RETURN_REFUND="RETURN_REFUND";
        public final static String RETURN_REFUND_LABEL="退货";

        public final static String EXCHANGE="EXCHANGE";
        public final static String EXCHANGE_LABEL="换货";


        public static String getStatusName(String status) {
            String name = Strings.EMPTY;
            switch (status) {
                case REFUND:
                    name = REFUND_LABEL;
                    break;
                case RETURN_REFUND:
                    name = RETURN_REFUND_LABEL;
                    break;
                case EXCHANGE:
                    name = EXCHANGE_LABEL;
                    break;
            }
            return name;
        }

    }


    /**
     * 审批类型
     */
    public static class DictTypeOrderAfterAuditStatus{
        public final static String ORDER_AFTER_AUDIT_STATUS="ORDER_AFTER_AUDIT_STATUS";
    }
    /**
     * 审批状态
     */
    public static class DictDataOrderAfterAuditStatus{

        public final static String PENDING="PENDING";
        public final static String PENDING_LABEL="待审核";


        public final static String PASS="PASS";
        public final static String PASS_LABEL="通过";


        public final static String REFUSE="REFUSE";
        public final static String REFUSE_LABEL="不通过";


        public static String getStatusName(String status) {
            String name = Strings.EMPTY;
            switch (status) {
                case PENDING:
                    name = PENDING_LABEL;
                    break;
                case PASS:
                    name = PASS_LABEL;
                    break;
                case REFUSE:
                    name = REFUSE_LABEL;
                    break;
            }
            return name;
        }

    }


    /**
     * 售后状态
     */
    public static class DictTypeOrderAfterStatus{
        public final static String ORDER_AFTER_STATUS="ORDER_AFTER_STATUS";
    }
    /**
     * 售后状态
     */
    public static class DictDataOrderAfterStatus{

        public final static String PENDING="PENDING";
        public final static String PENDING_LABEL="待审核";


        public final static String WAIT_REFUND="WAIT_REFUND";
        public final static String WAIT_REFUND_LABEL="待退款";


        public final static String WAIT_RETURN_IN="WAIT_RETURN_IN";
        public final static String WAIT_RETURN_IN_LABEL="待退货入库";


        public final static String WAIT_EXCHANGE_IN="WAIT_EXCHANGE_IN";
        public final static String WAIT_EXCHANGE_IN_LABEL="待换货入库";


        public final static String EXCHANGE_OUT="EXCHANGE_OUT";
        public final static String EXCHANGE_OUT_LABEL="换货已出库";


        public final static String SUCCESS="SUCCESS";
        public final static String SUCCESS_LABEL="售后成功";


        public final static String REFUSE="REFUSE";
        public final static String REFUSE_LABEL="终止受理";



        /**
         * 得到状态对应的名字
         * @param status
         * @return
         */
        public static String getStatusName(String status) {
            String name = Strings.EMPTY;
            switch (status) {
                case PENDING:
                    name = PENDING_LABEL;
                    break;
                case REFUSE:
                    name = REFUSE_LABEL;
                    break;
                case WAIT_REFUND:
                    name = WAIT_REFUND_LABEL;
                    break;
                case WAIT_RETURN_IN:
                    name = WAIT_RETURN_IN_LABEL;
                    break;
                case WAIT_EXCHANGE_IN:
                    name = WAIT_EXCHANGE_IN_LABEL;
                    break;
                case EXCHANGE_OUT:
                    name = EXCHANGE_OUT_LABEL;
                    break;
                case SUCCESS:
                    name = SUCCESS_LABEL;
                    break;
            }
            return name;
        }

    }


    /**
     * 退款状态
     */
    public static class DictTypeOrderAfterRefundStatus{
        public final static String ORDER_AFTER_REFUND_STATUS="ORDER_AFTER_REFUND_STATUS";
    }

    /**
     * 退款状态
     */
    public static class DictDataOrderAfterRefundStatus{

        //无需
        public static final String NONE = "NONE";
        public final static String NONE_LABEL="无需";

        //待退款
        public static final String WAIT_REFUND = "WAIT_REFUND";
        public final static String WAIT_REFUND_LABEL="等待退款";

        //退款中
        public static final String REFUNDING = "REFUNDING";
        public final static String REFUNDING_LABEL="退款中";

        //已退款
        public static final String SUCCESS = "SUCCESS";
        public static final String SUCCESS_LABLE = "已退款";

        //失败
        public static final String FAILS = "FAILS";
        public static final String FAILS_LABLE = "退款失败";
    }
















}
