package com.rocogz.syy.order.entity.settle;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.entity.goods.GoodsOrder;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 结算单明细表
 * </p>
 *
 * @author zhangmin
 * @since 2021-04-20
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderSettleOrderItem extends IdEntity {

    /**
     * 结算单编号
     * @see OrderSettleOrder#settleOrderCode
     */
    private String settleOrderCode;

    /**
     * 商品主订单号
     * @see GoodsOrder#orderCode
     */
    private String orderCode;

    /**
     * 商品子订单号
     * @see GoodsOrder#orderItemCode
     */
    private String orderItemCode;

    /**
     * 需要精算费用=actuary_amount+actuary_fee+logistic_fee
     */
    private BigDecimal needActuaryAmount;

    /**
     * 商品实际金额=商品结算价*数量
     */
    private BigDecimal realAmount;

    /**
     * 现金支付金额
     */
    private BigDecimal cashAmount;

    /**
     * 积分支付金额
     */
    private BigDecimal centAmount;

    /**
     * 现金支付(扣除支付费率和分期手续费)= cash_amount-actuary_fee
     */
    private BigDecimal deductCashAmount;

    /**
     * 实物商品物流费,精算物流费
     */
    private BigDecimal logisticFee;

    /**
     * 现金支付通道费
     */
    private BigDecimal cashPayFee;

    /**
     * 花呗分期手续费
     */
    private BigDecimal hbFqFee;

    /**
     * 现金支付手续费(精算手续费)= cash_pay_fee+hb_fq_fee
     */
    private BigDecimal actuaryFee;

    /**
     * 实际精算费用= real_amount-cash_amount
     */
    private BigDecimal actuaryAmount;

    /**
     * 主订单信息，前台显示用
     */
    @TableField(exist = false)
    private SaleOrder saleOrder;

    /**
     * 子订单信息，前台显示用
     */
    @TableField(exist = false)
    private GoodsOrder goodsOrder;
}
