/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.constant;

import com.rocogz.util.DateUtil;
import java.time.LocalDate;
import java.util.Date;

public enum StatisTimeRangeEnum {
    DAY("\u5f53\u5929", 6){

        @Override
        public String getStartTime() {
            String today = DateUtil.format((LocalDate)LocalDate.now(), (String)"yyyy-MM-dd");
            return today + " 00:00:00";
        }
    }
    ,
    WEEK("\u672c\u5468", 5){

        @Override
        public String getStartTime() {
            String firstDayThisWeek = DateUtil.getFirstDayOfWeek((Date)new Date());
            String dateTime = firstDayThisWeek + " 00:00:00";
            return dateTime;
        }

        @Override
        public String getEndTime() {
            String lastDayThisWeek = DateUtil.getLastDayOfWeek((Date)new Date());
            String dateTime = lastDayThisWeek + " 23:59:59";
            return dateTime;
        }
    }
    ,
    MONTH("\u8fd1\u4e00\u6708", 4){

        @Override
        public String getStartTime() {
            LocalDate monthAgo = LocalDate.now().plusMonths(-1L);
            return monthAgo.toString() + " 23:59:59";
        }
    }
    ,
    HALF_YEAR("\u8fd1\u534a\u5e74", 3){

        @Override
        public String getStartTime() {
            LocalDate halfYearAgo = LocalDate.now().plusMonths(-6L);
            return halfYearAgo.toString() + " 23:59:59";
        }
    }
    ,
    YEAR("\u8fd1\u4e00\u5e74", 2){

        @Override
        public String getStartTime() {
            LocalDate yearAgo = LocalDate.now().plusYears(-1L);
            return yearAgo.toString() + " 23:59:59";
        }
    }
    ,
    TOTAL("\u5168\u90e8", 1),
    CUSTOM("\u81ea\u5b9a\u4e49\u65f6\u95f4\u8303\u56f4", 10);

    private String label;
    private Integer seq;

    private StatisTimeRangeEnum(String label, Integer seq) {
        this.label = label;
        this.seq = seq;
    }

    public String getStartTime() {
        return null;
    }

    public String getEndTime() {
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public Integer getSeq() {
        return this.seq;
    }
}

