/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.dto;

import com.rocogz.syy.order.entity.goods.GoodsOrder;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;

public class PushDiscountCouponOrderDto {
    public static final String CANCELED_STATUS = "CNCL";
    public static final String SOLD_STATUS = "SOLD";
    private Integer orderId;
    private String orderCode;
    private String orderStatus;
    private String orderDate;
    private String orderTime;
    private String goodName;
    private String samsungItemCode;
    private String totalMoney;
    private String discountRedeemCode;
    private String cutDownMoney;
    private String totalCent;
    private String centOrderCode;
    private String payCashMoney;
    private String samsungMemCode;

    public static PushDiscountCouponOrderDto valueOf(GoodsOrder goodOrder) {
        BigDecimal HUNDRED = new BigDecimal(100);
        SaleOrder order = goodOrder.getSaleOrder();
        PushDiscountCouponOrderDto pushOrderDto = new PushDiscountCouponOrderDto();
        pushOrderDto.setOrderId(order.getId());
        pushOrderDto.setOrderCode(goodOrder.getOrderCode());
        if ("CANCELED".equalsIgnoreCase(order.getOrderStatus())) {
            pushOrderDto.setOrderStatus(CANCELED_STATUS);
        } else {
            pushOrderDto.setOrderStatus(SOLD_STATUS);
        }
        pushOrderDto.setOrderDate(order.getCreateTime().toLocalDate().toString());
        DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        pushOrderDto.setOrderTime(df.format(order.getCreateTime().toLocalTime()));
        pushOrderDto.setGoodName(goodOrder.getGoodName());
        pushOrderDto.setSamsungItemCode(goodOrder.getSamsungItemCode());
        BigDecimal totalMoney = goodOrder.getCash().multiply(HUNDRED).add(goodOrder.getCent()).multiply(new BigDecimal(goodOrder.getQuantity()));
        BigDecimal cutdownMoney = order.getCutDownCash().multiply(HUNDRED).add(order.getCutDownCent());
        BigDecimal payCashMoney = order.getTotalCash().multiply(HUNDRED);
        pushOrderDto.setTotalMoney(String.valueOf(totalMoney));
        pushOrderDto.setDiscountRedeemCode(order.getDiscountRedeemCode());
        pushOrderDto.setCutDownMoney(String.valueOf(cutdownMoney));
        pushOrderDto.setTotalCent(String.valueOf(order.getTotalCent()));
        pushOrderDto.setCentOrderCode(goodOrder.getOrderCode());
        pushOrderDto.setPayCashMoney(String.valueOf(payCashMoney));
        pushOrderDto.setSamsungMemCode(goodOrder.getSamsungMemId());
        return pushOrderDto;
    }

    public String toString() {
        String seperator = "|";
        StringBuffer orderInfoBuf = new StringBuffer();
        orderInfoBuf.append(this.orderCode).append(seperator).append(this.orderStatus).append(seperator).append(this.orderDate).append(seperator).append(this.orderTime).append(seperator).append(this.goodName).append(seperator).append(this.samsungItemCode).append(seperator).append(this.totalMoney).append(seperator).append(this.discountRedeemCode).append(seperator).append(this.cutDownMoney).append(seperator).append(this.totalCent).append(seperator).append(this.centOrderCode).append(seperator).append(this.payCashMoney).append(seperator).append(this.samsungMemCode);
        return orderInfoBuf.toString();
    }

    public PushDiscountCouponOrderDto setOrderId(Integer orderId) {
        this.orderId = orderId;
        return this;
    }

    public PushDiscountCouponOrderDto setOrderCode(String orderCode) {
        this.orderCode = orderCode;
        return this;
    }

    public PushDiscountCouponOrderDto setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
        return this;
    }

    public PushDiscountCouponOrderDto setOrderDate(String orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    public PushDiscountCouponOrderDto setOrderTime(String orderTime) {
        this.orderTime = orderTime;
        return this;
    }

    public PushDiscountCouponOrderDto setGoodName(String goodName) {
        this.goodName = goodName;
        return this;
    }

    public PushDiscountCouponOrderDto setSamsungItemCode(String samsungItemCode) {
        this.samsungItemCode = samsungItemCode;
        return this;
    }

    public PushDiscountCouponOrderDto setTotalMoney(String totalMoney) {
        this.totalMoney = totalMoney;
        return this;
    }

    public PushDiscountCouponOrderDto setDiscountRedeemCode(String discountRedeemCode) {
        this.discountRedeemCode = discountRedeemCode;
        return this;
    }

    public PushDiscountCouponOrderDto setCutDownMoney(String cutDownMoney) {
        this.cutDownMoney = cutDownMoney;
        return this;
    }

    public PushDiscountCouponOrderDto setTotalCent(String totalCent) {
        this.totalCent = totalCent;
        return this;
    }

    public PushDiscountCouponOrderDto setCentOrderCode(String centOrderCode) {
        this.centOrderCode = centOrderCode;
        return this;
    }

    public PushDiscountCouponOrderDto setPayCashMoney(String payCashMoney) {
        this.payCashMoney = payCashMoney;
        return this;
    }

    public PushDiscountCouponOrderDto setSamsungMemCode(String samsungMemCode) {
        this.samsungMemCode = samsungMemCode;
        return this;
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public String getOrderStatus() {
        return this.orderStatus;
    }

    public String getOrderDate() {
        return this.orderDate;
    }

    public String getOrderTime() {
        return this.orderTime;
    }

    public String getGoodName() {
        return this.goodName;
    }

    public String getSamsungItemCode() {
        return this.samsungItemCode;
    }

    public String getTotalMoney() {
        return this.totalMoney;
    }

    public String getDiscountRedeemCode() {
        return this.discountRedeemCode;
    }

    public String getCutDownMoney() {
        return this.cutDownMoney;
    }

    public String getTotalCent() {
        return this.totalCent;
    }

    public String getCentOrderCode() {
        return this.centOrderCode;
    }

    public String getPayCashMoney() {
        return this.payCashMoney;
    }

    public String getSamsungMemCode() {
        return this.samsungMemCode;
    }
}

