package com.rocogz.syy.order.dto.settle.order;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.constant.OrderSegmentEnum;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 导出 roco和三星历史的的电池券、后壳券订单数据
 * @author zhangmin
 * @since 2021-04-28
 */
@Setter @Getter
public class ExportCouponOrderParamDto {

    /**
     * @see OrderSegmentEnum
     */
    private String segment;

    /**
     * 下单时间范围
     */
    private String createStartTime;


    private String createEndTime;

    /**
     * 要查询的订单状态列表
     * @see OrderConstant.DictOrderStatus#FINISHED
     */
    private List<String> statusList;



}
