package com.rocogz.syy.order.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.constant.CreateOrderModeEnum;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import com.rocogz.syy.order.entity.pay.AlipayPayRecord;
import com.rocogz.syy.order.entity.settle.OrderSettleOrder;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单中心-商品订单,也是子订单
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-18
 */
@Setter @Getter
@Accessors(chain = true)
@TableName("order_goods_order")
public class GoodsOrder extends IdEntity {

    private static final long serialVersionUID = -6947173409061140577L;

    /**
     * 主订单编号
     */
    private String orderCode;

    /**
     * 子订单编号
     */
    @UniqueField
    private String orderItemCode;

    /**
     * 子订单状态
     * @see OrderConstant.DictOrderStatus
     */
    private String status;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 是否虚拟商品
     */
    private Boolean virtual;

    /**
     * 虚拟商品类型：卡券(CARD)、 充值(DEPOSIT)、 换壳券(COUPON)、 BATTERY_COUPON(电池券)、EXTENSION_INSURANCE(手机延保服务)、碎屏险(SCREEN_CRASH_INSURANCE)
     * @see OrderConstant.DictVirtualType
     */
    private String virtualType;

    /**
     * 商品供应商编号
     */
    private String supplierCode;

    /**
     * 商品供应商名称
     */
    private String supplierName;

    /**
     * sku编号
     */
    private String skuCode;

    /**
     * 福袋子订单原skuCode
     */
    private String originalSkuCode;

    /**
     * 主商品编号
     */
    private String goodCode;

    /**
     * 实物商品erp编号
     */
    private String erpCode;

    /**
     * 主商品名称
     */
    private String goodName;


    /**
     * 该商品是否支持花呗分期付款,订单详情发起再次支付时使用
     */
    private Boolean pcreditSupported;

    /**
     * 是否管家专项服务
     */
    private Boolean butlerService;

    /**
     * 购买管家服务商品时,如果使用了特权，则设置使用的特权Id
     * @see com.rocogz.syy.user.entity.steward.UserSteward#id
     */
    private Integer superPermissionId;

    /**
     * 是否三星专区商品
     */
    private Boolean samsungPrefecture;

    /**
     * 三星产品itemCode，例如：EF-RG988CBEGCN,折扣兑换码活动推送订单 需要传入此字段
     */
    private String samsungItemCode;

    /**
     * 碎屏险/手机延保服务:下单模式
     */
    private CreateOrderModeEnum createMode;

    /**
     * 白色,xl
     */
    private String attrValues;

    /**
     * 商品展示图片url
     */
    private String pictureUrl;

    /**
     * 商品支付方式: 纯积分(CENT)、现金抵扣积分(CASH_DEDUCTION)、固定积分+固定现金(CENT_WITH_CASH)
     */
    private String goodPayWay;

    /**
     * 运营服务费率: 4表示 4%
     */
    private BigDecimal operationServiceRate;

    /**
     * 发票税点, 12表示 12%
     */
    private BigDecimal taxRate;

    /**
     * 实物商品物流费
     */
    private BigDecimal logisticFee;

    /**
     * 结算价
     */
    private BigDecimal settlementPrice;

    /**
     * 真实结算价,特殊商品是倒入excel中的结算价,普通商品=settlementPrice
     */
    private BigDecimal realSettlementPrice;


    /**
     * 供应商结算状态
     * @see OrderConstant.DictSettleStatus
     */
    private String supplierSettleStatus;

    /**
     * 运营商结算状态
     * @see OrderConstant.DictSettleStatus
     */
    private String operatorSettleStatus;

    /**
     * 结算单号
     * @see OrderSettleOrder#settleOrderCode
     */
    private String settleOrderCode;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 积分价
     * （1）"纯积分"支付方式：纯积分
     * （2）"现金抵扣兑换"支付方式：总积分
     * （3）"固定积分+固定现金"支付方式： 固定积分
     */
    private BigDecimal cent;

    /**
     * "现金抵扣兑换"支付方式下：需支付的最少积分
     */
    private BigDecimal minCent;

    /**
     *
     * "固定积分+固定现金" 支付方式下：固定现金价
     */
    private BigDecimal cash;

    /**
     * 商品购买数量
     */
    private Integer quantity;

    /**
     * 充值手机号：如果购买的是 充值虚拟商品(话费,流量)
     */
    private String depositMobile;

    /**
     * 对接充值方：充值业务类型
     */
    private String chargeBizType;

    /**
     * 对接充值方：充值商品Id
     */
    private String  chargeProductId;

    /**
     * 我们的充值状态
     * @see OrderConstant.DictDepositStatus
     */
    private String depositStatus;

    /**
     * 充值结果描述：chenyun给的结果描述
     */
    private String depositDesc;

    /**
     * 小计：需支付订单现金金额[现金部分]
     */
    private BigDecimal totalCash;

    /**
     * 小计：需支付订单积分 [积分部分]
     */
    private BigDecimal totalCent;

    /**
     * 快递名称
     */
    private String expressDeliveryName;

    /**
     * 快递单号
     */
    private String expressDeliveryNumber;

    /**
     * 发货时间
     */
    private LocalDateTime sendTime;

    /**
     * 确认收货时间
     */
    private LocalDateTime receiveTime;

    /**
     * 完成时间
     */
    private LocalDateTime finishTime;

    /**
     * (1)三星生活助手订单,线上 模式(碎屏险,手机延保服务)
     *   线上模式：跳转过来传递的 coupon_sn 号
     * (2)如果是积分商城的 管家服务订单（CouponCode由我们自己生成）
     *     couponCode规则= B(电池券) / C（手机壳） / S（spen） + F700+ 0000001
     *
     *   如果是积分商城的 管家服务订单 B(电池券) / C（手机壳）确认收货完成时,要调用三星同步订单状态接口
     *
     *（3) 如果是SCME SC 配件产品,的 碎屏险,手机延保服务，则该字段保存的是 申领人Id,eventId
     *
     * (4)三星生活助手订单,线下 模式(碎屏险,手机延保服务)
     *    三星订单号
     */
    private String samsungCouponCode;

    /**
     * DI-碎屏险，EW-延保
     */
    private String samsungCouponType;

    /**
     *  线上碎屏险 申领人名字
     */
    private String samsungApplierName;

    /**
     *  线上碎屏险 申领日期
     */
    private LocalDate samsungApplyDate;


    /**
     * 管家服务,电池券/后壳券 有效开始日期
     * 有效开始时间 = 购买日期+1
     */
    private LocalDate couponStartDate;

    /**
     * 管家服务,电池券/后壳券 有效结束
     * 有效截止日期 = 购买日期+93
     ***/
    private LocalDate couponEndDate;

    /**
     * 三星会员Id号
     */
    private String samsungMemId;

    /**
     * 三星会员手机号
     */
    private String samsungMobile;

    /**
     * 三星会员名字
     */
    private String samsungMemName;

    /**
     * 三星会员 小程序unionId
     */
    private String unionId;

    /**
     *购买的管家专属服务商品的 手机IMEI码
     */
    private String imei;

    /**
     * (1) 管家服务商品订单的 手机型号编号：SM-F7000ZDACHC
     * (2) 线上碎屏险订单的 型号数据：根据couponCode 在字典表中匹配获取到手机型号,例如：A20s,该型号 结算时使用
     */
    private String mobileModel;

    /**
     * 管家服务："电池券/后壳券" 订单 维修码,用户在商城聚合服务-> 订单详情中点击确认完成时 输入此维修码
     */
    private String maintainCode;

    /**
     * 管家服务："电池券/后壳券" 订单 维修时间, 订单详情中点击确认完成 输入此维修码后的提交时间
     */
    private LocalDateTime maintainTime;

    /**
     * 支付结果是否通知成功到 三星生活助手
     * (1)推送订单数据到三星状态：只有 三星商品 isSamsungVirtual==true 或 管家服务商品(isPushCouponRequired==true) 才需要推送数据
     *
     * (2)创建充值订单成功状态
     */
    private Boolean notifySucceed;

    /**
     * 支付结果通知三星生活助手 失败后尝试次数：最多尝试5次,不包括第一次
     */
    private Integer notifyRetryTimes;

    /**
     * 支付结果通知三星生活助手 失败原因
     */
    private String notifyFailReason;

    /**
     * 支付结果通知：最后一次尝试时间
     */
    private LocalDateTime notifyLastRetryTime;

    /**
     * 订单是否退货，如果订单发起 退货售后服务，并退货完成了则为true
     */
    private Boolean returnGood;

    /**
     * 备注
     */
    private String remark;

    /**
     * 开发票申请编号
     */
    private String invoiceApplyCode;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     *现金如果使用了支付宝支付, 支付成功的 alipay支付记录
     */
    @TableField(exist = false)
    private AlipayPayRecord  alipaySuccessRecord;

    /**
     * 主订单信息
     */
    @TableField(exist = false)
    private SaleOrder saleOrder;

    /**
     * 是否是三星虚拟商品(碎屏险,手机延保服务)
     * @return
     */
    public boolean isSamsungVirtual() {
        boolean isSamsungVirtual = Boolean.TRUE.equals(virtual) && (OrderConstant.DictVirtualType.SCREEN_CRASH_INSURANCE.equals(virtualType) ||
                OrderConstant.DictVirtualType.EXTENSION_INSURANCE.equals(virtualType));
        return isSamsungVirtual;
    }


    /**
     * 订单支付成功以后：是否需要 推送券信息到三星系统
     * @return
     */
    public boolean isPushCouponRequired() {
        return Boolean.TRUE.equals(getButlerService()) && StringUtils.isNotEmpty(getSamsungCouponCode());
    }


    /**
     * 是否是福袋的 子订单
     * @return
     */
    public boolean isSuiteOrderItem() {
       return  StringUtils.isNotEmpty(originalSkuCode);
    }

}
