package com.rocogz.syy.order.dto;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * <dl>
 * <dd>Description: OrderCentPayDto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/8/19 16:49</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class OrderCentPayDto {
    /**
     * 会员编号 [必传]
     */
    @NotEmpty
    private String userCode;

    /**
     * 会员手机号 [必传]
     */
    @NotEmpty
    private String mobile;

    /**
     * 会员openid [必传]
     */
    @NotEmpty
    private String openId;

    /**
     * 订单编号
     */
    @NotEmpty
    private String orderCode;

    /**
     * 订单总金额
     */
    @NotNull
    private BigDecimal orderTotalAmount;

    /**
     * 券信息
     */
    private List<UserCouponPayItemDto> userCouponDtoList;
}
