package com.rocogz.syy.order.entity.after;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.entity.orders.OrderLog;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:订单操作日志 </dd>
 * <dd>@date: 2020/10/26</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@TableName("order_after_log")
@Setter
@Getter
@Accessors(chain = true)

public class OrderAfterLog extends IdEntity {

    /**
     * 售后订单
     */
    private String afterCode;


    /**
     * DictOrderAction
     */
    private String action;

    /**
     * 操作之前的状态
     */
    private String beforeStatus;

    /**
     * 操作之后的状态
     */
    private String afterStatus;

    /**
     * 操作人名字
     */
    private String actionUser;

    /**
     * 操作时间戳
     */
    private LocalDateTime createTime;

    /**
     *备注说明
     */
    private String remark;


    public static OrderAfterLog build() {
        OrderAfterLog log = new OrderAfterLog();
        log.setCreateTime(LocalDateTime.now());
        return log;
    }
}
