package com.rocogz.syy.order.dto.pay;

import com.rocogz.syy.order.constant.trace.TradeTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 支付宝支付传参dto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/6/28 10:07</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class AlipayUnifiedOrderParamDto {

    /**
     * 字段名：订单类型.
     * 是否必填：是
     */
    @NotNull
    private TradeTypeEnum rocoTradeType;

    /**
     * <pre>
     * 字段名：附加数据.
     * 是否必填：否
     * 公用回传参数，如果请求时传递了该参数，则返回给商户时会回传该参数。支付宝会在异步通知时将该参数原样返回。
     * 本参数必须进行 UrlEncode 之后才可以发送给支付宝。
     * </pre>
     */
    private String passbackParams;

    /**
     * <pre>
     * 字段名：商户订单号.
     * 变量名：out_trade_no
     * 是否必填：是
     * 类型：String(32)
     * 示例值：20150806125346
     * 描述：商户订单号。64 个字符以内的大小，可包含字母、数字、下划线。需保证该参数在商户端不重复
     * </pre>
     */
    @NotEmpty
    private String outTradeNo;

    /**
     * <pre>
     * 字段名：订单标题.
     * 变量名：subject
     * 是否必填：是
     * 类型：String(256)
     * 示例值： Iphone12 16G
     * </pre>
     */
    @NotEmpty
    private String subject;

    /**
     * <pre>
     * 字段名：通知地址.
     * 变量名：notify_url
     * 是否必填：否
     * 类型：String(256)
     * 示例值：http://api.test.alipay.net/atinterface/receive_notify.htm
     * 描述：接收支付宝支付异步通知回调地址，通知url必须为直接可访问的url，不能携带参数。
     *      roco车服目前定的回调地址是统一的，如果需要另外的回调地址请传入此参数，否则不用传。
     * </pre>
     */
    private String notifyUrl;

    /**
     * <pre>
     * 字段名：总金额.
     * 变量名：total_amount
     * 是否必填：是
     * 类型：BigDecimal
     * 示例值： 888
     * 描述：订单总金额，单位为元，精确到小数点后两位，取值范围为 [0.01,100000000]。金额不能为0。
     * </pre>
     */
    @NotNull
    private BigDecimal totalAmount;

    /**
     * <pre>
     * 字段名：订单失效时间.
     * 变量名：time_expire
     * 是否必填：否
     * 类型：String(14)
     * 示例值：2009-12-27 09:10:10
     * 描述：订单失效时间，格式为yyyy-MM-dd HH:mm:ss，如2009年12月27日9点10分10秒表示为2009-12-27 09:10:10。其他详见时间规则
     *   注意：最短失效时间间隔必须大于5分钟，默认为2小时
     * </pre>
     */
    private String timeExpire;

    /**
     *  <pre>
     * 字段名：支付成功跳转地址
     * 变量名: return_url
     * 是否必填：否
     * 类型：String(14)
     * 示例值：http://api.test.alipay.net/atinterface/receive_notify.htm
     * 描述：在支付宝支付页面支付成功后的跳转地址
     *  </pre>
     */
    private String returnUrl;

    /**
     *  <pre>
     * 字段名：取消支付跳转地址
     * 变量名: quit_url
     * 是否必填：否
     * 类型：String(14)
     * 示例值：http://api.test.alipay.net/atinterface/receive_notify.htm
     * 描述：在支付宝支付页面取消支付的跳转地址
     *  </pre>
     */
    private String quitUrl;

    /**
     *  <pre>
     * 字段名：花呗分期数目
     * 变量名: hb_fq_num
     * 是否必填：否
     * 类型：int
     * 示例值：3
     * 描述：花呗分期数目
     *  </pre>
     */
    private Integer hbFqNum;

    /**
     *  <pre>
     * 字段名：花呗分期商家承担的手续费率百分比
     * 变量名: hb_fq_seller_percent
     * 是否必填：否
     * 类型：int
     * 示例值：3
     * 描述：花呗分期商家承担的手续费率百分比, 传入100代表100%.只允许0或100, 默认三星承担手续费
     *  </pre>
     */
    private Integer hbFqSellerPercent = 100;

    /**
     *  <pre>
     * 字段名：用户编号
     * 是否必填：是
     * 类型：string
     * 示例值：UC202011110001
     * 描述：用户编号
     *  </pre>
     */
    @NotNull
    private String userCode;

    /**
     *  <pre>
     * 字段名：渠道
     * 是否必填：是
     * 类型：string
     * 示例值：PC
     * 描述：用户访问的渠道，区分调用对应的接口
     *  </pre>
     */
    @NotNull
    private String visitChannel;
}
