package com.rocogz.syy.order.dto.goods;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.entity.goods.GoodsOrderDeliveryAddress;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 创建商品订单 Dto
 * @author ranxiangfu
 * @date 2020/8/19
 */
@Data
@Accessors(chain = true)
public class CreateGoodsOrderDto {

    //三星生活助手订单的 coupon信息
    private String samsungCouponCode;
    private String samsungCouponType;


    //三星会员Id
    private String samsungMemId;
    //三星会员绑定的手机号
    private String samsungMobile;

    /**
     * 订单编号 [如果是外部生成订单编号，则传入此参数]
     */
    private String orderCode;

    /**
     * 会员编号 [必传]
     */
    private String userCode;

    /**
     * 会员手机号
     */
    private String mobile;

    /**
     * 会员openid [必传]
     */
    private String openId;

    /**
     * 下单来源平台编号，如：三星积分商城  [必传]
     * @see OrderConstant#DICT_PLATFORM_CODE_CENT_MALL
     */
    @NotEmpty
    private String platformCode;

    /**
     * 下单渠道：WAP，PC，管理后台,接口调用 [必传]
     *
     * @see OrderConstant.DictChannel
     */
    @NotEmpty
    private String channel;

    /**
     * 商品编号
     */
    private String goodCode;

    /**
     * 商品名称
     */
    @NotEmpty
    private String goodName;

    /**
     * sku编号
     */
    @NotEmpty
    private String skuCode;

    /**
     * 商品展示图片url
     */
    private String pictureUrl;

    /**
     * 白色,xl
     */
    private String attrValues;

    /**
     * 是否虚拟商品
     */
    @NotNull
    private Boolean virtual;

    /**
     * 虚拟商品类型：卡券(CARD)、 充值(DEPOSIT)、 碎屏险(SCREEN_CRASH_INSURANCE)、 电池券/换壳券(COUPON)
     */
    private String virtualType;

    /**
     * 该商品是否支持花呗分期付款,订单详情发起再次支付时使用
     */
    private Boolean pcreditSupported;

    /**
     * 商品供应商编号
     */
    private String supplierCode;

    /**
     * 商品供应商名称
     */
    private String supplierName;


    /**
     * 备注
     */
    private String remark;


    /**
     * 商品支付方式: 纯积分(CENT)、现金抵扣积分(CASH_DEDUCTION)、固定积分+固定现金(CENT_WITH_CASH)
     */
    private String goodPayWay;


    /**
     * 商品订单支付模式 (POINT:积分;  CASH:现金; POINT_AND_CASH:积分+现金)
     * @see com.rocogz.syy.order.constant.OrderConstant.DictGoodsOrderPayWay
     */
    private String payWay;


    /**
     * 现金使用的支付方式：微信/支付宝
     * @see com.rocogz.syy.order.constant.OrderConstant.DictPayWay
     */
    private String cashPayWay;

    /**
     * 积分价
     * （1）"纯积分"支付方式：纯积分
     * （2）"现金抵扣兑换"支付方式：总积分
     * （3）"固定积分+固定现金"支付方式： 固定积分
     */
    private BigDecimal cent;

    /**
     * "现金抵扣兑换"支付方式下：需支付的最少积分
     */
    private BigDecimal minCent;

    /**
     *
     * "固定积分+固定现金" 支付方式下：固定现金价
     */
    private BigDecimal cash;

    /**
     * 商品购买数量
     */
    private Integer quantity;

    /**
     * 充值手机号：如果购买的是 充值虚拟商品(话费,流量)
     */
    private String depositMobile;

    /**
     * 需支付订单现金金额[现金部分]
     */
    private BigDecimal totalCash = BigDecimal.ZERO;

    /**
     * 需支付订单积分 [积分部分]
     */
    private BigDecimal totalCent = BigDecimal.ZERO;

    /**
     * 收货地址信息
     */
    private GoodsOrderDeliveryAddress deliveryAddress;

}

