package com.rocogz.syy.order.dto.trace;

import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.time.ZoneOffset;

/**
 * @author zhangmin
 * @date 2020/5/28
 */
@Setter @Getter
public class TraceDto {

    public static final TraceDto EMPTY_TRACE_DTO = new TraceDto();

    public LocalDateTime callStartTime;

    /**
     * 返回消息
     */
    private String respMsg;

    /**
     * 返回状态码
     */
    private String respCode;


    /**
     * 出错的类名
     */
    private String errorClassName;

    /**
     * 出错代码行号
     */
    private Integer errorLine;

    /**
     * 出错的方法名称
     */
    private String errorMethod;

    /**
     * 错误堆栈信息
     */
    private String stackTrace;

    /**
     * 接口耗时（毫秒数）
     */
    private Long spendMillis;

    public void setStartTimeAndCalcSpend(LocalDateTime callStartTime) {
        this.callStartTime = callStartTime;
        if(callStartTime==null) {
            return;
        }
        Long startMillis = callStartTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        spendMillis = System.currentTimeMillis() - startMillis;
    }

}
