package com.rocogz.syy.order.dto.jms;

import com.rocogz.syy.order.entity.goods.GoodsOrder;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 碎屏险,手机延保服务 支付结果通知到三星生活助手
 * @author zhangmin
 * @date 2020/11/16
 */
@Setter @Getter
public class NotifyPayResultToSamsungMsg {

    //失败后 是第几次尝试推送,不包括第一次
    private Integer retryTimes;

    /**
     * 是否管家服务商品
     */
    private Boolean butlerService;

    /**
     * 我们积分商城订单号
     */
    private String orderCode;

    /**
     * 会员coupon返回三星传送的值
     */
    private String coupon;

    /**
     * 订单类型,Coupon类型：DI-碎屏险，EW-延保，QY-爱奇艺， GIFT-礼品兑换，ALL-多类型合并支付
     */
    private String type;

    /**
     * 会员ID
     */
    private String memID;


    /**
     * 支付单号,可以传入积分商城的订单号
     */
    private String tranID;


    /**
     * 支付现金(无现金支付为0)
     */
    private String payCash;

    /**
     * 支付积分(无积分支付为0)
     */
    private String payPoint;

    /**
     * 是否分期: Y-分期，N-不分期
     */
    private String payStageYN;

    /**
     * 分期期数，如分期此参数必填
     */
    private String payStageNum;


    //以下字段是管家服务商品 券信息同步字段
    private String mobileModel;
    private LocalDateTime createTime;
    private String imei;


    public static NotifyPayResultToSamsungMsg valueOf(GoodsOrder goodOrder) {
        NotifyPayResultToSamsungMsg payResultMsg = new NotifyPayResultToSamsungMsg();
        payResultMsg.setCoupon(goodOrder.getSamsungCouponCode());
        payResultMsg.setType(goodOrder.getSamsungCouponType());
        payResultMsg.setOrderCode(goodOrder.getOrderCode());
        payResultMsg.setTranID(goodOrder.getOrderCode());
        payResultMsg.setMemID(goodOrder.getSamsungMemId());
        //三星支付现金单位是：分
        double payCash = goodOrder.getTotalCash().doubleValue() *100;
        payResultMsg.setPayCash(String.valueOf((int)payCash));
        payResultMsg.setPayPoint(String.valueOf(goodOrder.getTotalCent().intValue()));

        payResultMsg.setMobileModel(goodOrder.getMobileModel());
        payResultMsg.setCreateTime(goodOrder.getCreateTime());
        payResultMsg.setImei(goodOrder.getImei());

        payResultMsg.setButlerService(goodOrder.getButlerService());

        payResultMsg.setPayStageYN("N");

        payResultMsg.setRetryTimes(goodOrder.getNotifyRetryTimes());

        if(goodOrder.getAlipaySuccessRecord()!=null  &&
                goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum()!=null &&
                goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum()>0) {
            payResultMsg.setPayStageYN("Y");
            payResultMsg.setPayStageNum(String.valueOf(goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum()));
        }

        return payResultMsg;
    }





}
