package com.rocogz.syy.order.dto.after;

import com.rocogz.syy.order.constant.after.OrderAfterSourceEnum;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * <dl>
 * <dd>Description:创建售后单参数,虽然设计的结构是按多商品设计。
 * 但此次项目为单商品下单，所以只是按照单商品处理</dd>
 * <dd>@date: 2020/10/27</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class AfterOrderCreateParamDto  {
    /**
     *订单编号
     */
    @NotBlank(message = "请传递订单编号")
    private String orderCode;

    /**
     * 售后原因
     */
    @NotBlank(message = "请传递售后原因")
    private String reason;

    /**
     * 售后类型,换货/退货
     * @See OrderAfterConstant.DictDataOrderAfterType
     */
    @NotBlank(message = "请传递售后类型")
    private String afterType;

    /**
     * 不用传递,依据调用的接口自行补全
     */
    private transient OrderAfterSourceEnum afterSource;

    /**
     * 售后图片附件
     */
    private List<AfterOrderCreateAttachmentParamDto> attachmentList;

}
