/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.constant;

import com.google.common.collect.Lists;
import com.rocogz.syy.order.constant.StatisTimeRangeEnum;
import java.util.List;

public class OrderStatisOption {
    private StatisTimeRangeEnum timeRange;
    private String goodCode;
    private String userCode;
    private String depositMobile;
    private List<String> statusList;
    private String startTime;
    private String endTime;

    public OrderStatisOption() {
    }

    public OrderStatisOption(StatisTimeRangeEnum timeRange) {
        this(timeRange, null, null, null, Lists.newArrayList((Object[])new String[]{"FINISHED"}));
    }

    public OrderStatisOption(StatisTimeRangeEnum timeRange, String userCode, String depositMobile, String goodCode) {
        this(timeRange, userCode, depositMobile, goodCode, Lists.newArrayList((Object[])new String[]{"PENDING_PAY", "PENDING_DELIVERY", "DELIVERED", "FINISHED"}));
    }

    public OrderStatisOption(StatisTimeRangeEnum timeRange, String userCode, String depositMobile, String goodCode, List<String> statusList) {
        this.timeRange = timeRange;
        if (!StatisTimeRangeEnum.CUSTOM.equals((Object)timeRange)) {
            this.startTime = timeRange.getStartTime();
            this.endTime = timeRange.getEndTime();
        }
        this.userCode = userCode;
        this.depositMobile = depositMobile;
        this.goodCode = goodCode;
        this.statusList = statusList;
    }

    public OrderStatisOption(String startTime, String endTime) {
        this.timeRange = StatisTimeRangeEnum.CUSTOM;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public StatisTimeRangeEnum getTimeRange() {
        return this.timeRange;
    }

    public String getGoodCode() {
        return this.goodCode;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getDepositMobile() {
        return this.depositMobile;
    }

    public List<String> getStatusList() {
        return this.statusList;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setTimeRange(StatisTimeRangeEnum timeRange) {
        this.timeRange = timeRange;
    }

    public void setGoodCode(String goodCode) {
        this.goodCode = goodCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setDepositMobile(String depositMobile) {
        this.depositMobile = depositMobile;
    }

    public void setStatusList(List<String> statusList) {
        this.statusList = statusList;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }
}

