package com.rocogz.syy.order.constant;

import java.math.BigDecimal;

/**
 * 常量
 * @author：zhangmin
 * @since：2020/4/6
 */
public final class OrderConstant {

    public static final String APPLICATION_NAME = "order-base-service";


    /**
     * 取消订单申请 审核操作后回调地址
     */
    public static final String CANCEL_ORDER_APPROVEMENT_CALL_BACK_URL = "/api/order/cancelOrderApproveCallBlack";


    /**
     * 该平台码 来源于 基础服务系统中：basic_docking_platform表
     */
    public static final String DICT_PLATFORM_CODE_CENT_MALL = "SAMSUANG_CENT_MALL";

    /**
     * 调用其他平台下单接口时, 最多尝试5次[不包括第一次]
     */
    public static final int MAX_RETRY_TIMES = 5;

    /**
     * 元和分的转换进制, 微信支付时使用的是分为单位.
     */
    public static final BigDecimal YUAN_FEE_EXCHANGE = new BigDecimal(100);
    /**
     * 金额保留的小数位数
     */
    public static final int SCALE = 3;

    /**
     * 订单类型
     */
    public static class DictOrderType {
        //字典类型编号
        public static final String TYPE_CODE = "ORDER_TYPE";

        //=== 下面是字典值

        /**
         * 商品订单
         * 商品订单状态变化流程如下
         * 车主端下单（PENDING_DELIVERY）-> 后台管理发货(DELIVERED) -> 车主端用户确认收货（FINISHED）
         */
        public static final String GOODS_ORDER = "GOODS_ORDER";

        /**
         * 福袋订单,即组合订单，包括的订单状态（待付款、待发货、待收货、已完成）
         */
        public static final String SUITE_ORDER = "SUITE_ORDER";
    }


    /**
     * 下单状态
     */
    public static class DictOrderStatus {
        //字典类型编号
        public static final String TYPE_CODE = "SALE_ORDER_STATUS";

        //=== 下面是字典值

        //待付款 （加油电子券订单刚创建时状态是待支付, 支付成功后是  "处理中"）
        public static final String PENDING_PAY = "PENDING_PAY";


        /**
         * 碎屏险商品支付完成以后,状态就是 已完成
         * <p>
         * 发货流程：有发货步骤的订单，支付完成后就是待发货
         * (1)虚拟商品发货流程：支付完成以后，自动发送一条虚拟商品发货的消息到mq,自动发货(占用虚拟卡密,扣减库存， 管家服务虚拟商品 为已发货，其他虚拟商品 状态更新为已完成)
         * (2)实物商品发货流程：
         */
        public static final String PENDING_DELIVERY = "PENDING_DELIVERY";


        //已发货(有发货步骤的订单，发货之后就是已发货)
        public static final String DELIVERED = "DELIVERED";

        //已完成
        public static final String FINISHED = "FINISHED";

        //已取消
        public static final String CANCELED = "CANCELED";
    }


    /**
     * 订单的支付模式
     */
    public static class DictGoodsOrderPayWay {
        public static final String TYPE_CODE = "GOODS_ORDER_PAY_WAY";

        // 积分支付
        public static final String POINT = "POINT";

        // 现金支付
        public static final String CASH = "CASH";

        // 积分 + 现金混合支付
        public static final String POINT_AND_CASH = "POINT_AND_CASH";
    }


    /**
     * 订单支付记录的 支付方式================================
     */
    public static class DictPayWay {
        //字典类型编号
        public static final String TYPE_CODE = "PAYMENT_WAY";

        //=== 下面是字典值

        //积分支付
        public static final String CENT = "CENT";

        //现金支付之 微信支付
        public static final String WEIXIN = "WEIXIN";

        //现金支付之 支付宝支付
        public static final String ALIPAY = "ALIPAY";

        //现金支付之 蚂蚁花呗分期
        public static final String HBPCREDIT = "HBPCREDIT";
    }


    /**
     * 支付手续费费率
     */
    public static class DictPayFeeRate {

        //字典类型编号
        public static final String TYPE_CODE = "PAYMENT_FEE_RATE";

        //=== 下面是字典值

        //蚂蚁花呗分期 12期分期手续费率,7.5%
        public static final String HBPCREDIT_12Q_FEE = "HBPCREDIT_12Q_FEE";
    }



    /**
     * 支付单的 支付状态
     */
    public static class DictPayStatus {
        //字典类型编号
        public static final String TYPE_CODE = "PAYMENT_STATUS";

        //=== 下面是字典值
        //未支付
        public static final String UN_PAY = "UNPAY";
        //部分支付
        public static final String PART_PAY = "PART_PAY";
        //支付完成
        public static final String PAIED = "PAIED";
    }


    /**
     * 订单退款状态
     */
    public static class DictRefundStatus {
        //
        //字典类型编号
        public static final String TYPE_CODE = "ORDER_REFUND_STATUS";

        //=== 下面是字典值
        //退款中
        public static final String REFUNDING = "REFUNDING";

        //已退回
        public static final String REFUNDED = "REFUNDED";
    }

    /**
     * 订单 操作动作,用来记录操作流水
     */
    public static final class DictOrderAction {

        //字典类型编号
        public static final String TYPE_CODE = "ORDER_ACTION";

        //=== 下面是字典值

        //创建订单
        public static final String CREATE = "CREATE";

        //支付订单
        public static final String PAY = "PAY";

        //取消订单
        public static final String CANCEL = "CANCEL";

        //逻辑删除
        public static final String DELETE = "DELETE";

        //发货
        public static final String SEND = "SEND";

        // 确认收货
        public static final String CONFIRM_RECEIPT = "CONFIRM_RECEIPT";

        // 售后
        public static final String AFTER = "AFTER";

        // 查询卡密服务
        public static final String QUERY_VCARD="QUERY_VCARD";
    }

    public static class DictExpressDeliveryName {
        // 快递名称字典表
        public static final String TYPE_CODE = "EXPRESS_DELIVERY_NAME";
    }

    /**
     * 字典表类型
     */
    public class DictType {
        /**
         * roco订单类型
         */
        public final static String ROCO_TRADE_TYPE = "ROCO_TRADE_TYPE";
        /**
         * 微信订单支付状态
         */
        public final static String WX_TRADE_STATE = "WX_TRADE_STATE";
        /**
         * 微信支付交易类型
         */
        public final static String WX_TRADE_TYPE = "WX_TRADE_TYPE";
        /**
         * 用户支付时使用的银行类型
         */
        public final static String WX_BANK_TYPE = "WX_BANK_TYPE";

        /**
         * 微信退款状态
         */
        public final static String WX_REFUND_STATUS = "WX_REFUND_STATUS";
        /**
         * 微信订单退款发起来源
         */
        public final static String WX_REFUND_REQUEST_SOURCE = "WX_REFUND_REQUEST_SOURCE";
    }

    /**
     * 支付流水状态字典值
     */
    public static class DictPaymentFlowStatus {
        public static final String TYPE_CODE = "PAYMENT_FLOW_STATUS";
        /**
         * 支付中
         */
        public static final String PAYING = "PAYING";
        /**
         * 失效
         */
        public static final String INVALID = "INVALID";
        /**
         * 关闭
         */
        public static final String CLOSED = "CLOSED";
        /**
         * 完成
         */
        public static final String COMPLETE = "COMPLETE";
    }

    /**
     * 退款流水状态字典值
     */
    public static class DictRefundFlowStatus {
        public static final String TYPE_CODE = "REFUND_FLOW_STATUS";
        /**
         * 退款中
         */
        public static final String REFUNDING = "REFUNDING";
        /**
         * 退款失败
         */
        public static final String FAIL = "FAIL";
        /**
         * 退款成功
         */
        public static final String SUCCESS = "SUCCESS";
    }

    /**
     * 微信支付方式
     */
    public static class DictWxPayTradeType {
        public static final String TYPE_CODE = "WX_PAY_TRADE_TYPE";
        /**
         * JSAPI支付（或小程序支付）
         */
        public static final String JSAPI = "JSAPI";
        /**
         * NATIVE--Native支付
         */
        public static final String NATIVE = "NATIVE";
        /**
         * APP--app支付
         */
        public static final String APP = "APP";
        /**
         * MWEB--H5支付
         */
        public static final String MWEB = "MWEB";
    }

    /**
     * 支付宝订单状态
     */
    public static class DictAlipayTradeStatus {
        public static final String TYPE_CODE = "ALIPAY_TRADE_STATUS";
        /**
         * 交易创建，等待买家付款
         */
        public static final String WAIT_BUYER_PAY = "WAIT_BUYER_PAY";
        /**
         * 未付款交易超时关闭，或支付完成后全额退款
         */
        public static final String TRADE_CLOSED = "TRADE_CLOSED";
        /**
         * 交易支付成功
         */
        public static final String TRADE_SUCCESS = "TRADE_SUCCESS";
        /**
         * 交易结束，不可退款
         */
        public static final String TRADE_FINISHED = "TRADE_FINISHED";
    }

    /**
     * 下订单渠道
     */
    public static class UserVisitChannel {
        //字典类型编号
        public static final String TYPE_CODE = "CHANNEL";

        //PC网页
        public static final String WEB = "WEB";

        //手机WAP
        public static final String WAP = "WAP";

        //微信小程序
        public static final String WX_MINI = "WX_MINI";

        //微信公众号
        public static final String WX_MP = "WX_MP";

        //手机APP
        public static final String APP = "APP";

        //管理后台
        public static final String ADMIN = "ADMIN";

        //三星生活助手 APP,目前只有线上碎屏险是 这个渠道
        public static final String SAMSUNG_APP = "SAMSUNG_APP";

        //接口调用
        public static final String API_CALL = "API_CALL";

    }

    /**
     * 发票类型
     */
    public static class OrderInvoiceType {

        //  在字典表中的编码
        public static final String DICT_CODE = "INVOICE_TYPE";

        // 增值税普通发票
        public static final String NORMAL_INVOICE = "NORMAL_INVOICE";
    }

    /**
     * 发票抬头类型
     */
    public static class OrderInvoiceTitleType {

        //  在字典表中的编码
        public static final String DICT_CODE = "INVOICE_TITLE_TYPE";

        // 个人或事业单位
        public static final String PERSONAL = "PERSONAL";

        // 企业
        public static final String COMPANY = "COMPANY";
    }

    /**
     * 发票接收方式
     */
    public static class OrderInvoiceReceiveWay {

        // 手机
        public static final String MOBILE = "MOBILE";

        // 邮箱
        public static final String EMAIL = "EMAIL";
    }

    /**
     * 开票申请状态
     */
    public static class OrderInvoiceStatus {

        //  在字典表中的编码
        public static final String DICT_CODE = "INVOICE_STATUS";

        // 待处理
        public static final String PENDING_PROCESS = "PENDING_PROCESS";

        // 开票中
        public static final String MAKE_OUT_INVOICE = "MAKE_OUT_INVOICE";

        // 已开票
        public static final String COMPLETED_INVOICE = "COMPLETED_INVOICE";
    }


    /**
     * 充值订单充值状态
     */
    public static class DictDepositStatus {

        //字典类型编号
        public static final String DEPOSIT_STATUS = "DEPOSIT_STATUS";

        //=== 下面是字典值

        //待充值
        public static final String PENDING_DEPOSIT = "PENDING_DEPOSIT";

        //充值处理中
        public static final String PROCESSING = "PROCESSING";

        //充值完成
        public static final String FINISHED = "FINISHED";

        //充值失败
        public static final String FAILED = "FAILED";

    }



    /**
     * 申请状态
     */
    public static class DictApplyStatus {

        //字典类型编号
        public static final String ORDER_APPLY_STATUS = "ORDER_APPLY_STATUS";

        //审批中
        public static final String PENDING_APPROVE = "PENDING_APPROVE";

        //审批不通过
        public static final String REFUSE = "REFUSE";

        //审批通过
        public static final String PASS = "PASS";

    }



    /**
     * 结算单 结算状态
     */
    public static class DictSettleStatus {

        //字典类型编号
        public static final String TYPE_CODE = "SETTLE_STATUS";

        //=== 下面是字典值

        //未结算,商品订单结算状态,刚创建订单结算状态是 未结算
        public static final String UN_SETTLE = "UN_SETTLE";

        //初始化,尚未提交时,创建的结算单状态为初始化
        public static final String INIT = "INIT";

        //结算中
        public static final String PENDING_SETTLE = "PENDING_SETTLE";

        //已结算
        public static final String SETTLED = "SETTLED";

        //已作废
        public static final String INVALID = "INVALID";

    }



    /**
     * 结算单类型
     */
    public static class DictSettleOrderType {

        //字典类型编号
        public static final String TYPE_CODE = "SETTLE_ORDER_TYPE";

        //=== 下面是字典值

        //普通商品
        public static final String COMMON_PRODUCT = "COMMON_PRODUCT";


        //特殊商品,包括【延保服务、碎屏险、后壳券、电池券】
        public static final String SPECIAL_PRODUCT = "SPECIAL_PRODUCT";

    }

    /**
     * 结算单日志操作Action
     */
    public static class DictSettleLogAction {

        public static final String CREATE = "创建";
        public static final String EDIT = "编辑";
        public static final String INVALID = "作废";
        public static final String SUPPLIER_SETTLE = "供应商结算";
        public static final String OPERATOR_SETTLE = "运营商结算";

    }


    /**
     * 结算主体,结算对象
     */
    public static class DictSettleSubjectType {

        //字典类型编号
        public static final String TYPE_CODE = "SETTLE_SUBJECT_TYPE";

        //=== 下面是字典值

        //供应商
        public static final String SUPPLIER = "SUPPLIER";

        //运营商
        public static final String OPERATOR = "OPERATOR";
    }




    public static class DictVirtualType {

        //字典类型编号
        public static final String TYPE_CODE = "VIRTUAL_PRODUCT_TYPE";

        //=== 下面是字典值

        //实物商品
        public static final String REAL = "real";

        //充值商品
        public static final String DEPOSIT = "DEPOSIT";

        //卡密
        public static final String CARD = "CARD";

        //电池券
        public static final String BATTERY_COUPON = "BATTERY_COUPON";

        //后壳券
        public static final String COUPON = "COUPON";

        //碎屏险
        public static final String SCREEN_CRASH_INSURANCE = "SCREEN_CRASH_INSURANCE";

        //延保服务
        public static final String EXTENSION_INSURANCE = "EXTENSION_INSURANCE";

    }


    /**
     *折扣兑换码兑换的订单，通过oss文本文件方式 推送订单状态
     */
    public static class DictOssPushOrderStatus {
        //字典类型编号
        public static final String TYPE_CODE = "ORDER_DISCOUNT_OSS_PUSH_STATUS";

        //=== 下面是字典值
        //待推送
        public static final String PENDING = "PENDING";

        //销售订单推送
        public static final String SOLD_PUSH = "SOLD_PUSH";

        //取消订单推送
        public static final String CANCELED_PUSH = "CANCELED_PUSH";
    }


}
