package com.rocogz.syy.order.entity.pay;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 微信和支付宝支付的 支付流水
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_payment_flow")
public class OrderPaymentFlow extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 支付单流水号
     */
    private String flowCode;

    /**
     * 订单编号
     * @see SaleOrder#orderCode
     */
    private String orderCode;

    /**
     * 支付方式: WX 微信 ALIPAY 支付宝 POINT 积分
     * @see OrderConstant.DictPayWay
     */
    private String payWay;

    /**
     * 支付金额(积分支付时要根据比例转换为现金金额保存),单位：元
     */
    private BigDecimal payAmount;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 支付状态：PAYING 支付中  INVALID 失效  COMPLETE 完成
     * @see OrderConstant.DictPaymentFlowStatus
     */
    private String status;

    /**
     * 支付单完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 支付单失效时间
     */
    private LocalDateTime invalidTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
