package com.rocogz.syy.order.entity.qrcode;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 二维码记录表 entity</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-11-25 10:20:32</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_samsung_qrcode")
public class OrderSamsungQrcode extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 场景码
     */
    private String sceneCode;

    /**
     * 类型: H5-h5路径
     *       MA-本小程序路径
     *       OMA-其它小程序路径
     */
    private String type;

    /**
     * type为OMA的小程序appid
     */
    private String appId;

    /**
     * 二维码图片地址（阿里云）
     */
    private String qrUrl;

    /**
     * 跳转目标地址
     */
    private String url;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
