package com.rocogz.syy.order.constant;

import com.rocogz.util.DateUtil;
import lombok.Getter;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 统计时间范围方式
 *
 * @author zhangmin
 * @date 2020/5/26
 */
@Getter
public enum StatisTimeRangeEnum {


    DAY("当天",6) {
        @Override
        public String getStartTime() {
            String today = DateUtil.format(LocalDate.now(), DateUtil.YYYY_MM_DD);
            return today + DateUtil.START_TIME;
        }
    },


    WEEK("本周",5) {
        @Override
        public String getStartTime() {
            String firstDayThisWeek = DateUtil.getFirstDayOfWeek(new java.util.Date());
            String dateTime = firstDayThisWeek + DateUtil.START_TIME;
            return  dateTime;
        }

        @Override
        public String getEndTime() {
            String lastDayThisWeek = DateUtil.getLastDayOfWeek(new java.util.Date());
            String dateTime = lastDayThisWeek + DateUtil.END_TIME;
            return dateTime;
        }
    },

    MONTH("近一月",4) {
        @Override
        public String getStartTime() {
            LocalDate monthAgo = LocalDate.now().plusMonths(-1);
            return monthAgo.toString() + DateUtil.END_TIME;
        }
    },


    HALF_YEAR("近半年",3) {
        @Override
        public String getStartTime() {
            LocalDate halfYearAgo = LocalDate.now().plusMonths(-6);
            return halfYearAgo.toString() + DateUtil.END_TIME;
        }
    },

    YEAR("近一年",2) {
        @Override
        public String getStartTime() {
            LocalDate yearAgo = LocalDate.now().plusYears(-1);
            return yearAgo.toString() + DateUtil.END_TIME;
        }
    },


    TOTAL("全部",1),

    CUSTOM("自定义时间范围",10);

    private String label;

    //统计校验顺序,顺序值越小，越先统计校验
    private Integer seq;

    StatisTimeRangeEnum(String label,Integer seq) {
        this.label = label;
        this.seq = seq;
    }


    public String getStartTime() {
        return null;
    }

    public String getEndTime() {
        return null;
    }

}
