package com.rocogz.syy.order.dto.goods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import com.rocogz.util.DateUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * 管理后台-> 结算 搜索子订单 条件
 *
 * @author zhangmin
 * @date 2020/8/18
 */
@Data
public class SettleAdminSearchOrderItemParamDto {

    private Boolean export = Boolean.FALSE;

    /**
     * 所选供应商编号
     */
    private String supplierCode;

    /**
     * 结算订单类型
     *
     * @see OrderConstant.DictSettleOrderType
     */
    private String settleOrderType;

    /**
     * 订单编号,在主订单号或子订单号列上搜索
     */
    private String orderCode;

    private String goodsCode;
    private String erpCode;
    private String skuCode;

    private String goodsName;

    /**
     * 三星会员手机号
     */
    private String samsungMobile;

    /**
     * 三星会员名字
     */
    private String samsungMemName;

    /**
     * 子订单状态
     */
    private String orderItemStatus;

    /**
     * 订单支付模式 (POINT:积分;  CASH:现金; POINT_AND_CASH:积分+现金)
     *
     * @see SaleOrder#payWay
     */
    private String payWay;

    /**
     * 是否虚拟商品
     */
    private Boolean virtualGoods;

    //按照虚拟商品类型搜索
    private String virtualType;

    /**
     * 是否三星专区商品
     */
    private Boolean samsungPrefecture;

    /**
     * 下单时间
     */
    private String createStartTime;

    private String createEndTime;

    /**
     * 完成时间
     */
    private String finishStartTime;

    private String finishEndTime;


    //已创建的 结算单号 【添加查询到的订单 使用查询条件】
    private String settleOrderCode;
    //创建人，登录账户的用户名 【添加查询到的订单 使用查询条件】
    private String createUser;

    private Integer limit = 20;

    private Integer page = 1;

    @JsonIgnore
    public String getSamsungMemNameLike() {
        if (StringUtils.isEmpty(samsungMemName)) {
            return null;
        }

        return StringUtils.wrap(samsungMemName, "%");
    }


    @JsonIgnore
    public String getGoodsNameLike() {
        if (StringUtils.isEmpty(goodsName)) {
            return null;
        }

        return StringUtils.wrap(goodsName, "%");
    }


    public String getCreateEndTime() {
        if (StringUtils.isEmpty(createEndTime)) {
            return null;
        }

        return createEndTime + DateUtil.END_TIME;
    }


    public String getFinishEndTime() {
        if (StringUtils.isEmpty(finishEndTime)) {
            return null;
        }

        return finishEndTime + DateUtil.END_TIME;
    }

}
