package com.rocogz.syy.order.entity.pay;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.entity.orders.OrderRefund;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 订单中心-微信退款记录
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_wx_pay_refund_record")
public class WxPayRefundRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * roco订单编码(微信支付时的订单编码)
     * @see SaleOrder#orderCode
     */
    private String rocoTradeNo;

    /**
     * roco支付流水号
     * @see OrderPaymentFlow#flowCode
     */
    private String rocoPaymentFlowCode;

    /**
     * roco退款流水号
     * @see OrderRefundFlow#flowCode
     */
    private String rocoRefundFlowCode;

    /**
     * roco退款订单号
     * @see OrderRefund#refundCode
     */
    private String rocoRefundNo;

    /**
     * roco订单类型
     */
    private String rocoTradeType;

    /**
     * 记录微信回调之后，我们调用内部接口的返回状态码，用于判断调用内部接口是否成功，可以利用微信的多次回调机制进行重试
     */
    private String rocoResCode;

    /**
     * 记录微信回调之后，我们调用内部接口的次数
     */
    private Integer rocoTryCount;

    /**
     * 微信用户openid
     */
    private String wxUserOpenid;

    /**
     * 微信退款单号,微信退款流水号
     */
    private String wxRefundId;

    /**
     * 订单总金额(单位为分)
     */
    private Integer wxTotalFee;

    /**
     * 退款总金额(单位为分)
     */
    private Integer wxRefundFee;

    /**
     * 退款原因
     */
    private String wxRefundDesc;

    /**
     * 微信支付订单号
     * @see WxPayRecord#wxTransactionId
     */
    private String wxTransactionId;

    /**
     * 退款入账账户, 例：招商银行信用卡0403
     */
    private String wxRefundRecvAccout;

    /**
     * 微信退款完成时间，格式为yyyy-MM-dd HH:mm:ss
     */
    private String wxRefundSuccessTime;

    /**
     * 微信退款状态: PROCESSING:退款中 SUCCESS-退款成功; CHANGE-退款异常; REFUNDCLOSE—退款关闭
     */
    private String wxRefundStatus;

    /**
     * 退款发起来源: API-接口; VENDOR_PLATFORM-商户平台
     */
    private String wxRefundRequestSource;

    /**
     * 微信退款结果回调地址
     */
    private String wxNotifyUrl;

    /**
     * 微信退款接口返回的业务结果
     */
    private String wxRefundResultCode;

    /**
     * 微信退款回调roco传入的业务结果
     */
    private String wxResResultCode;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
