package com.rocogz.syy.order.entity.pay;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 退款流水(支付支付或微信支付的退款流水)
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_refund_flow")
public class OrderRefundFlow extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 退款流水号
     */
    private String flowCode;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 支付方式: WX 支付宝 ALIPAY 支付宝 POINT 积分
     */
    private String payWay;

    /**
     * 总支付金额
     */
    private BigDecimal payAmount;

    /**
     * 此次退款金额
     */
    private BigDecimal refundAmount;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 退款状态：REFUNDING 退款中 SUCCESS 退款成功 FAIL 退款失败
     */
    private String status;

    /**
     * 退款完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
