package com.rocogz.syy.user.dto;

import lombok.Data;
import org.springframework.util.StringUtils;

/**
 * <dl>
 * <dd>Description: AdminUserListSearchParamDto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/11/30 9:35</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
public class AdminUserListSearchParamDto {
    private String userCode;
    private String openid;
    private String wxName;
    /**
     * 三星会会员手机号.
     */
    private String mobile;
    private String status;
    /**
     * 三星会员名称.
     */
    private String memFullName;
    /**
     * 三星会员编号
     */
    private String memId;
    private String unionid;
    private String startTime;
    private String endTime;
    private Integer page;
    private Integer limit;

    /**
     * 给模糊查询的字段拼接like字符串.
     */
    public void concatLike() {
        if (!StringUtils.isEmpty(this.wxName)) {
            this.wxName = "%" + this.wxName + "%";
        }
    }
}
