package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户中心-用户登录日志
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-17
 */
@Data
@TableName("user_login_log")
public class UserLoginLog extends IdEntity {

    private static final long serialVersionUID = 3825359971279085657L;
    /**
     * 用户编号
     */
    private String userCode;

    /**
     * openid
     */
    private String wxOpenid;

    /**
     * 登录时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    private LocalDateTime loginTime;

    /**
     * 登录ip
     */
    private String loginIp;

    /**
     * 登录地点经纬度
     */
    private String loginLatlng;

    /**
     * 登录省份
     */
    private String loginProvince;

    /**
     * 登录城市
     */
    private String loginCity;

    /**
     * 登录区/镇
     */
    private String loginDistrict;

    /**
     * 登录地点详细地址
     */
    private String loginAddress;

    /**
     * 登录渠道, WX_MINI:微信小程序; WX_MP:微信公众号; WAP:手机WAP; WEB:PC网页; APP:三星生活助手APP
     */
    private String loginChannel;

    /**
     * 登录时三星账户绑定的手机号码.
     */
    private String samsungMemBindPhone;
}
