package com.rocogz.syy.user.entity.info;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 三星账户信息表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-11-04
 */
@Data
@TableName("user_samsung_mem_info")
public class SamsungMemInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 会员号
     */
    private String memId;

    /**
     * 姓名
     */
    private String memFullName;

    /**
     * 电话号码
     */
    private String memPhone;

    /**
     * 电子邮箱
     */
    private String memEmail;

    /**
     * 性别，F-女性 M-男性
     */
    private String memSex;

    /**
     * 用户编号
     */
    private String memLevel;

    /**
     * 生日
     */
    private String memBirthday;

    /**
     * 注册时间
     */
    private String memRegDate;

    /**
     * 微信unionid
     */
    private String memWechatUnionid;

    /**
     * 支付宝unionid
     */
    private String memAlipayUnionid;

    /**
     * 证件类型：SOCL-身份证 PASS-护照 CAR-军官证
     */
    private String idType;

    /**
     * 状态: A:激活, D:删除, I:非激活, L:锁定
     */
    private String status;

    /**
     * 证件号码(密文)
     */
    private String identityId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
