package com.rocogz.syy.activity.entity.reo.receive;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 川分员工之家 领取审核活动参与记录得到的礼品,当参与审核通过后保存得到的礼品
 * </p>
 *
 * @author zhangmin
 * @since 2023-04-12
 */
@Setter
@Getter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ActivityReceiveAuditJoinRecordGift extends ActivityReceiveBaseGift {

    /**
     * 参与记录编号
     * @see com.rocogz.merchant.entity.scm.MerchantScmInformation#applyNo
     */
    private String joinCode;

    /**
     * 到供应链系统下单的业务单号 传入此businessCode = joinCode+顺序号
     * @see com.rocogz.merchant.entity.scm.MerchantScmInformation#businessCode
     */
    private String scmBusinessCode;

    /**
     * 供应链下游订单编号
     * 上游触发模式：是根据平台产品配置的，分：发放时触发上游 或 领取时触发上游
     * 如果用户券发放后，并且触发了上游订单成功，则此用户券才能使用
     */
    private String scmOrderCode;

    /**
     * 供应链下游订单 重试次数,不包括第1次，如果要重试，则查询重试次数是[1-6]范围内的重试
     */
    private Integer scmOrderRetryNum;

    /**
     * 供应链下游下单失败原因
     */
    private String scmOrderReason;

    /**
     * 供应链下单时间
     */
    private LocalDateTime scmOrderRetryTime;


}
