package com.rocogz.syy.activity.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 活动中心-活动基准券配置
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_coupon_config")
public class ActivityCouponConfig extends UserTimeEntity implements Serializable {

    private static final long serialVersionUID = 1438343620264609247L;
    /**
     * 活动编码
     */
    private String activityCode;

    /**
     * 基准券编码
     */
    private String couponCode;

    /**
     * 总数量
     */
    private Integer totalQuantity;

    /**
     * 剩余数量
     */
    private Integer remainingQuantity;

    /**
     * 领取方式(按人领/按车领)
     */
    private String receiveType;

    /**
     * 每人可领取总数量
     */
    private Integer eachPersonTotalQuantity;

    /**
     * 上下线状态
     */
    private String status;

    /**
     * 排序号
     */
    private Integer sortNum;

}
