package com.rocogz.syy.activity.client;

import com.rocogz.syy.activity.entity.*;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * The interface Activity client service.
 *
 * @author：liangyongtong
 * @since：2020/3/25
 */
public interface IActivityClientService {
    /**
     * 分页查询活动基本信息.
     *
     * @param type                       活动类型
     * @param code                       编码
     * @param name                       名称
     * @param issuingBodyCode            发放主体编码
     * @param prefectureCode             专区编码
     * @param status                     活动上下架状态
     * @param progressStatus             活动进行状态
     * @param activityStartTimeStartTime 活动开始时间范围查询-起始时间
     * @param activityStartTimeEndTime   活动开始时间范围查询-结束时间
     * @param activityEndTimeStartTime   活动结束时间范围查询-开始时间
     * @param activityEndTimeEndTime     活动结束时间范围查询-结束时间
     * @param page                       the page
     * @param limit                      the limit
     * @return the page table
     */
    @GetMapping("/api/activity/activity-basic-info/pageQuery")
    PageTable<ActivityBasicInfo> pageQueryActivityBasicInfo(@RequestParam(value = "type", required = false) String type,
                                                            @RequestParam(value = "code", required = false) String code,
                                                            @RequestParam(value = "name", required = false) String name,
                                                            @RequestParam(value = "issuingBodyCode", required = false) String issuingBodyCode,
                                                            @RequestParam(value = "prefectureCode", required = false) String prefectureCode,
                                                            @RequestParam(value = "status", required = false) String status,
                                                            @RequestParam(value = "progressStatus", required = false) String progressStatus,
                                                            @RequestParam(value = "activityStartTimeStartTime", required = false) String activityStartTimeStartTime,
                                                            @RequestParam(value = "activityStartTimeEndTime", required = false) String activityStartTimeEndTime,
                                                            @RequestParam(value = "activityEndTimeStartTime", required = false) String activityEndTimeStartTime,
                                                            @RequestParam(value = "activityEndTimeEndTime", required = false) String activityEndTimeEndTime,
                                                            @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                            @RequestParam(value = "limit", defaultValue = "20") Integer limit);
    /**
     * Gets activity basic info by id.
     *
     * @param id the id
     * @return the activity basic info by id
     */
    @GetMapping("/api/activity/activity-basic-info")
    Response<ActivityBasicInfo> getActivityBasicInfoById(@RequestParam("id") Integer id);

    /**
     * Gets activity basic info by code.
     *
     * @param code the code
     * @return the activity basic info by code
     */
    @GetMapping("/getByCode")
    Response<ActivityBasicInfo> getActivityBasicInfoByCode(@RequestParam("code") String code);

    /**
     * Save or update activity basic info response.
     *
     * @param activityBasicInfo the activity basic info
     * @return the response
     */
    @PostMapping("/api/activity/activity-basic-info")
    Response<String> saveOrUpdateActivityBasicInfo(@RequestBody ActivityBasicInfo activityBasicInfo);

    /**
     * List activity coupon config response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-coupon-config/listByActivityCode")
    Response<List<ActivityCouponConfig>> listActivityCouponConfig(@RequestParam(value = "activityCode") String activityCode);

    /**
     * Gets activity coupon config by id.
     *
     * @param id the id
     * @return the activity coupon config by id
     */
    @GetMapping("/api/activity/activity-coupon-config")
    Response<ActivityCouponConfig> getActivityCouponConfigById(@RequestParam("id") Integer id);

    /**
     * Save or update activity coupon config response.
     *
     * @param activityCouponConfig the activity coupon config
     * @return the response
     */
    @PostMapping("/api/activity/activity-coupon-config")
    Response saveOrUpdateActivityCouponConfig(@RequestBody ActivityCouponConfig activityCouponConfig);

    /**
     * Delete activity coupon config response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-coupon-config")
    Response deleteActivityCouponConfig(@RequestParam("id") Integer id);

    /**
     * Page query activity log page table.
     *
     * @param activityCode the activity code
     * @param page         the page
     * @param limit        the limit
     * @return the page table
     */
    @GetMapping("/api/activity/activity-log/listByActivityCode")
    PageTable<ActivityLog> pageQueryActivityLog(@RequestParam(value = "activityCode") String activityCode,
                                                @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                @RequestParam(value = "limit", defaultValue = "20") Integer limit);


    /**
     * Save activity log response.
     *
     * @param activityLog the activity log
     * @return the response
     */
    @PostMapping("/api/activity/activity-log")
    Response saveActivityLog(@RequestBody ActivityLog activityLog);

    /**
     * List activity receive rule response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-receive-rule/listByActivityCode")
    Response<List<ActivityReceiveRule>> listActivityReceiveRule(@RequestParam(value = "activityCode") String activityCode);

    /**
     * Gets activity receive rule by id.
     *
     * @param id the id
     * @return the activity receive rule by id
     */
    @GetMapping("/api/activity/activity-receive-rule")
    Response<ActivityReceiveRule> getActivityReceiveRuleById(@RequestParam("id") Integer id);

    /**
     * Save or update activity receive rule response.
     *
     * @param activityCouponConfig the activity coupon config
     * @return the response
     */
    @PostMapping("/api/activity/activity-receive-rule")
    Response saveOrUpdateActivityReceiveRule(@RequestBody ActivityReceiveRule activityCouponConfig);

    /**
     * Delete activity receive rule response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-receive-rule")
    Response deleteActivityReceiveRule(@RequestParam("id") Integer id);

    /**
     * List activity available prefecture response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-available-prefecture/listByActivityCode")
    Response<List<ActivityAvailablePrefecture>> listActivityAvailablePrefecture(@RequestParam(value = "activityCode") String activityCode);
}
