package com.rocogz.syy.activity.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 活动中心-活动基本信息
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_basic_info")
public class ActivityBasicInfo extends UserTimeEntity implements Serializable {

    private static final long serialVersionUID = 4690245402505160977L;
    /**
     * 活动编码
     */
    private String code;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 活动类型
     */
    private String type;

    /**
     * 活动说明
     */
    private String description;

    /**
     * 活动开始时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    private LocalDateTime startTime;

    /**
     * 活动结束时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    private LocalDateTime endTime;

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 发放主体名称
     */
    private String issuingBodyName;

    /**
     * 活动上下架状态
     */
    private String status;

    /**
     * 排序号
     */
    private Integer sortNum;

    /**
     * 活动进行状态
     */
    @TableField(exist = false)
    private String progressStatus;

    /**
     * 活动投放专区编码列表
     */
    @TableField(exist = false)
    private List<String> availablePrefectureCodeList;
}
