package com.rocogz.syy.activity.constant;

import java.time.format.DateTimeFormatter;

/**
 * <dl>
 * <dd>Description: 用户中心服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/22 17:03</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class ActivityConstant {
    private ActivityConstant(){}

    /**
     * 日期时间格式化
     */
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    /**
     * 字典值
     */
    public class DictData {
        private DictData(){}

        /**
         * 通用启用、停用
         */
        public static final String COMMON_STATUS_OPEN_CODE = "OPEN";
        public static final String COMMON_STATUS_LOCK_CODE = "LOCK";

        /**
         * 活动领券规则字典表编码
         */
        public static final String ACTIVITY_RECEIVE_RULE_CODE = "ACTIVITY_RECEIVE_RULE";

        /**
         * 活动领券规则字典值编码
         */
        public static final String ACTIVITY_RECEIVE_RULE_BEFORE_REGISTER_TIME_CODE = "BEFORE_REGISTER_TIME";
        public static final String ACTIVITY_RECEIVE_RULE_AFTER_REGISTER_TIME_CODE = "AFTER_REGISTER_TIME";
        public static final String ACTIVITY_RECEIVE_RULE_REGISTER_TIME_START_CODE = "REGISTER_TIME_START";
        public static final String ACTIVITY_RECEIVE_RULE_REGISTER_TIME_END_CODE = "REGISTER_TIME_END";
        public static final String ACTIVITY_RECEIVE_RULE_CA_MOBILE_CODE = "CA_MOBILE";
        public static final String ACTIVITY_RECEIVE_RULE_CA_CAR_CODE = "CA_CAR";
        public static final String ACTIVITY_RECEIVE_RULE_CORPORATE_CUSTOMER_CODE = "CORPORATE_CUSTOMER";
        public static final String ACTIVITY_RECEIVE_RULE_ALL_CUSTOMER_CODE = "ALL_CUSTOMER";

        /**
         * 活动进行状态
         */
        public static final String ACTIVITY_PROGRESS_STATUS_NOT_STARTED_CODE = "NOT_STARTED";
        public static final String ACTIVITY_PROGRESS_STATUS_IN_PROGRESS_CODE = "IN_PROGRESS";
        public static final String ACTIVITY_PROGRESS_STATUS_END_CODE = "END";

        /**
         * 活动上下架状态
         */
        public static final String ACTIVITY_STATUS_DRAFT_CODE = "DRAFT";
        public static final String ACTIVITY_STATUS_STAYINGON_CODE = "STAYINGON";
        public static final String ACTIVITY_STATUS_UP_LIST_CODE = "UP_LIST";
        public static final String ACTIVITY_STATUS_DOWN_LIST_CODE = "DOWN_LIST";
        public static final String ACTIVITY_STATUS_INVALID_CODE = "INVALID";

        /**
         * 线上领券活动基准券配置上下架状态
         */
        public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_STATUS_STAYINGON_CODE = "STAYINGON";
        public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_STATUS_UP_LIST_CODE = "UP_LIST";
        public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_STATUS_DOWN_LIST_CODE = "DOWN_LIST";

    }
}
