package com.rocogz.syy.activity.constant;

import java.time.format.DateTimeFormatter;

/**
 * <dl>
 * <dd>Description: 用户中心服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/22 17:03</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class ActivityConstant {
    private ActivityConstant(){}

    /**
     * 日期时间格式化
     */
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    /**
     * redisKey前缀
     */
    public static final String ACTIVITY_KEY_PREFIX = "ACTIVITY:";
    public static final String ACTIVITY_RECEIVE_ONLINE_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:";
    public static final String ACTIVITY_RECEIVE_ONLINE_RECEIVE_INFO_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:RECEIVE_INFO:";
    public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_LIST_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:COUPON_LIST:";
    public static final String ACTIVITY_BASIC_INFO_KEY_PREFIX = "ACTIVITY:BASIC_INFO:";
    public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_CONFIG_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:COUPON_CONFIG:";
    public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_CONFIG_REMAINING_QUANTITY_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:COUPON_CONFIG:REMAINING_QUANTITY:";
    public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_CONFIG_RECEIVE_ERROR_QUANTITY_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:COUPON_CONFIG:RECEIVE_ERROR_QUANTITY:";
    public static final String ACTIVITY_RECEIVE_ONLINE_RULE_CONFIG_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:RULE_CONFIG:";
    public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_CONFIG_LIST_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:COUPON_CONFIG:LIST:";
    public static final String ACTIVITY_RECEIVE_ONLINE_RULE_CONFIG_LIST_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:RULE_CONFIG:LIST:";

    /** 珠海9块9洗车活动前缀 **/
    public static final String ACTIVITY_ZH_WASH_CAR_KEY_PREFIX = "ACTIVITY:ZH_WASH_CAR:";
    public static final String ACTIVITY_ZH_WASH_CAR_LOCK_KEY_PREFIX = "ACTIVITY:ZH_WASH_CAR:LOCK:";
    public static final String ACTIVITY_ZH_WASH_CAR_RECEIVE_RULE_LIST_KEY_PREFIX = "ACTIVITY:ZH_WASH_CAR:RECEIVE_RULE:LIST:";

    /**
     * MQ交换器名称
     */
    public static final String MQ_EXCHANGE_NAME = "ACTIVITY_EXCHANGE";

    /**
     * 线上领券领取信息路由名称
     */
    public static final String MQ_RECEIVE_ONLINE_RECEIVE_INFO_ROUTE_KEY = "ACTIVITY_RECEIVE_ONLINE_RECEIVE_INFO";

    /**
     * 字典值
     */
    public class DictData {
        private DictData(){}

        /**
         * 通用启用、停用
         */
        public static final String COMMON_STATUS_OPEN_CODE = "OPEN";
        public static final String COMMON_STATUS_LOCK_CODE = "LOCK";

        /**
         * 通用是否
         */
        public static final String COMMON_YES = "Y";
        public static final String COMMON_NO = "N";

        /**
         * 活动领券规则字典表编码
         */
        public static final String ACTIVITY_RECEIVE_RULE_CODE = "ACTIVITY_RECEIVE_RULE";

        /**
         * 活动领券规则字典值编码
         */
        public static final String ACTIVITY_RECEIVE_RULE_BEFORE_REGISTER_TIME_CODE = "BEFORE_REGISTER_TIME";
        public static final String ACTIVITY_RECEIVE_RULE_AFTER_REGISTER_TIME_CODE = "AFTER_REGISTER_TIME";
        public static final String ACTIVITY_RECEIVE_RULE_REGISTER_TIME_START_CODE = "REGISTER_TIME_START";
        public static final String ACTIVITY_RECEIVE_RULE_REGISTER_TIME_END_CODE = "REGISTER_TIME_END";
        public static final String ACTIVITY_RECEIVE_RULE_CA_MOBILE_CODE = "CA_MOBILE";
        public static final String ACTIVITY_RECEIVE_RULE_CA_CAR_CODE = "CA_CAR";
        public static final String ACTIVITY_RECEIVE_RULE_CORPORATE_CUSTOMER_CODE = "CORPORATE_CUSTOMER";
        public static final String ACTIVITY_RECEIVE_RULE_ALL_CUSTOMER_CODE = "ALL_CUSTOMER";

        /**
         * 领券规则值
         */
        public static final String ACTIVITY_RECEIVE_RULE_VALUE_Y = "Y";
        public static final String ACTIVITY_RECEIVE_RULE_VALUE_N = "N";

        /**
         * 活动进行状态
         */
        public static final String ACTIVITY_PROGRESS_STATUS_NOT_STARTED_CODE = "NOT_STARTED";
        public static final String ACTIVITY_PROGRESS_STATUS_IN_PROGRESS_CODE = "IN_PROGRESS";
        public static final String ACTIVITY_PROGRESS_STATUS_END_CODE = "END";

        /**
         * 活动上下架状态
         */
        public static final String ACTIVITY_STATUS_DRAFT_CODE = "DRAFT";
        public static final String ACTIVITY_STATUS_STAYINGON_CODE = "STAYINGON";
        public static final String ACTIVITY_STATUS_UP_LIST_CODE = "UP_LIST";
        public static final String ACTIVITY_STATUS_DOWN_LIST_CODE = "DOWN_LIST";
        public static final String ACTIVITY_STATUS_INVALID_CODE = "INVALID";

        /**
         * 线上领券活动基准券配置上下架状态
         */
        public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_STATUS_STAYINGON_CODE = "STAYINGON";
        public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_STATUS_UP_LIST_CODE = "UP_LIST";
        public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_STATUS_DOWN_LIST_CODE = "DOWN_LIST";

        /**
         * 珠海9块9洗车活动，领取限制-时间范围类型
         */
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_FOR_EVEY = "FOR_EVEY";
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_YEARLY = "YEARLY";
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_QUARTERLY = "QUARTERLY";
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_MONTHLY = "MONTHLY";
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_WEEKLY = "WEEKLY";
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_DAILY = "DAILY";

        /**
         * 活动领券模式字典编码
         */
        public static final String ACTIVITY_COUPON_RECEIVE_PATTERN_CODE = "ACTIVITY_COUPON_RECEIVE_PATTERN";
        /**
         * 活动领券模式-普通模式
         */
        public static final String ACTIVITY_COUPON_RECEIVE_PATTERN_NORMAL_CODE = "NORMAL_PATTERN";
        /**
         * 活动领券模式-口令模式
         */
        public static final String ACTIVITY_COUPON_RECEIVE_PATTERN_PASSWORD_CODE = "PASSWORD_PATTERN";

    }
}
