package com.rocogz.syy.activity.entity.send;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 赠送活动基本信息
 * </p>
 *
 * @author yinshihao
 * @since 2021-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_log")
public class ActivitySendMainInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 活动编码
     */
    private String code;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 活动类型(平台活动: PLATFORM_ACTIVE, 主体活动: BODY_ACTIVE )
     */
    private String type;

    /**
     * 投放平台编码
     */
    private String putPlatformCode;

    /**
     * 投放平台miniAppid
     */
    private String putPlatformMiniAppid;

    /**
     * 活动描述
     */
    private String description;

    /**
     * 活动开始时间
     */
    private LocalDateTime startTime;

    /**
     * 活动结束时间
     */
    private LocalDateTime endTime;

    /**
     * 赠送产品名称(前端页面展示时显示)
     */
    private String sendGoodsName;

    /**
     * 活动上下架状态
     */
    private String status;

    /**
     * 排序号
     */
    private Integer sort;

    /**
     * 兑换产品编码
     */
    private String exchangeGoodsCode;

    /**
     * 赠送发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 赠送面值比例
     */
    private BigDecimal sendRatio;

    /**
     * 赠送最大面值
     */
    private BigDecimal sendMaxAmount;

    /**
     * 赠送最小面值
     */
    private BigDecimal sendMinAmount;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 赠送活动中配置的赠送产品列表
     */
    @TableField(exist = false)
    private List<ActivitySendGoodsInfo> sendGoodsInfoList;
}
