package com.rocogz.syy.activity.entity.send;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 赠送活动产品信息
 * </p>
 *
 * @author yinshihao
 * @since 2021-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class ActivitySendGoodsInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 活动编码
     */
    private String activeCode;

    /**
     * 产品编码
     */
    private String goodsCode;

    /**
     * 赠送顺序
     */
    private Integer sort;

    /**
     * 活动上下架状态
     */
    private String status;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
