package com.rocogz.syy.activity.dto.send.request;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 积分兑换油卡赠送产品活动信息查询条件DTO
 * @date：2021/8/12
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
public class ActivitySendMainInfoSearchDto {

    /**
     * 活动编号
     */
    private String code;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 投放平台编码列表
     */
    private List<String> miniAppCodes;

    /**
     * 赠送发放主体编码列表
     */
    private List<String> issuingBodyCodes;

    /**
     * 活动开始时间最小值
     */
    private LocalDateTime startTimeMinTime;

    /**
     * 活动开始时间最大值
     */
    private String startTimeMaxTime;

    /**
     * 活动结束时间最小值
     */
    private String endTimeMinTime;

    /**
     * 活动结束时间最大值
     */
    private String endTimeMaxTime;

    /**
     * 活动进行状态(未开始：PENDING、进行中：PROCESSING、已结束：END)
     */
    private String progessStatus;

    /**
     * 当前时间
     */
    private LocalDateTime now = LocalDateTime.now();

    /**
     * 活动上架状态
     */
    private String status;

    /**
     * 当前页
     */
    private Long page;

    /**
     * 每页记录数
     */
    private Long limit;

    /**
     * 是否导出操作
     */
    private Boolean export;
}
